/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    public int height;
    public double width;
    public String imageName;
    public String buttonText;
    public Font font;
    public Color foreground = Color.black;
    public boolean selected = false;
    float lineHeight;
    boolean enabled = true;
    Image image = null;
    Image downImage = null;
    JDialog parent = null;
    private JDesktopPane jDesktopPane1;

    public ButtonPanel() {
        this.initComponents();
    }

    public ButtonPanel(JDialog parent, int width, int height, Image image, Font font, String buttonText, Color foreground) {
        this.initComponents();
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.image = image;
        this.font = font;
        this.buttonText = buttonText;
        this.foreground = foreground;
        this.setBounds(0, 0, width, height);
        this.setFont(font);
    }

    public ButtonPanel(JDialog parent, int width, int height, Image image, Image downImage, Font font, String buttonText, Color foreground) {
        this.initComponents();
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.image = image;
        this.downImage = downImage;
        this.font = font;
        this.buttonText = buttonText;
        this.foreground = foreground;
        this.setBounds(0, 0, width, height);
        this.setFont(font);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2;
        int imageHeight;
        int imageWidth;
        Rectangle area;
        super.paint(g);
        if (this.selected && this.downImage != null) {
            area = this.getBounds();
            imageWidth = this.image.getWidth(this);
            imageHeight = this.image.getHeight(this);
            g2 = (Graphics2D)g;
            g2.drawImage(this.downImage, 0, 0, area.width, area.height, 0, 0, Math.round(imageWidth), Math.round(imageHeight), this);
        } else if (this.image != null) {
            area = this.getBounds();
            imageWidth = this.image.getWidth(this);
            imageHeight = this.image.getHeight(this);
            g2 = (Graphics2D)g;
            g2.drawImage(this.image, 0, 0, area.width, area.height, 0, 0, Math.round(imageWidth), Math.round(imageHeight), this);
        }
        if (this.buttonText != null) {
            if (this.enabled) {
                this.setForeground(this.foreground);
            } else {
                this.setForeground(Color.LIGHT_GRAY);
            }
            Font font = this.getFont();
            FontMetrics metrics = g.getFontMetrics(font);
            Rectangle bounds = this.getBounds();
            double recWidth = bounds.width;
            double recHeight = bounds.height;
            String[] lines = this.wrapText(this.buttonText, g, font, recWidth - 10.0);
            double textHeight = (float)lines.length * (this.lineHeight - 5.0f);
            float fontFactor = this.lineHeight / 24.0f;
            float y = (float)(recHeight - textHeight) / 2.0f + 20.0f * fontFactor - 5.0f;
            for (int i = 0; i < lines.length; ++i) {
                String thisLine = lines[i].trim();
                Rectangle2D rectangle = metrics.getStringBounds(thisLine, g);
                float x = (float)(recWidth - rectangle.getWidth()) / 2.0f;
                Graphics2D g22 = (Graphics2D)g;
                g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g22.drawString(thisLine, x, y);
                y += this.lineHeight;
            }
        }
    }

    public String[] wrapText(String text, Graphics g, Font font, double width) {
        ArrayList<String> result = new ArrayList<String>();
        FontMetrics metrics = g.getFontMetrics(font);
        this.lineHeight = 0.0f;
        int len = text.length();
        String line = "";
        String word = "";
        String temp = "";
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            temp = word + c;
            Rectangle2D rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > (double)this.lineHeight) {
                this.lineHeight = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                result.add(word);
                word = "";
            }
            word = word + c;
            temp = line + word;
            rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > (double)this.lineHeight) {
                this.lineHeight = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                if (line.length() > 0) {
                    result.add(line);
                }
                line = "";
            } else if (c == '\n') {
                line = line + word;
                word = "";
                result.add(line);
                line = "";
            }
            if (c != ' ') continue;
            line = line + word;
            word = "";
        }
        if (word.length() > 0) {
            line = line + word;
        }
        if (line.length() > 0) {
            result.add(line);
        }
        len = result.size();
        String[] returnValue = new String[len];
        for (int i = 0; i < len; ++i) {
            returnValue[i] = (String)result.get(i);
        }
        return returnValue;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setDownImage(Image image) {
        this.downImage = image;
    }

    public void setText(String buttonText) {
        this.buttonText = buttonText;
        this.repaint();
    }

    public String getText() {
        return this.buttonText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void initComponents() {
        this.jDesktopPane1 = new JDesktopPane();
        this.setBackground(new Color(204, 204, 204));
        this.setFont(new Font("Microsoft Sans Serif", 1, 14));
        this.setPreferredSize(new Dimension(50, 50));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ButtonPanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ButtonPanel.this.formMouseReleased(evt);
            }
        });
        this.setLayout(null);
    }

    private void formMousePressed(MouseEvent evt) {
        this.selected = true;
        this.repaint();
    }

    private void formMouseReleased(MouseEvent evt) {
        this.selected = false;
        this.repaint();
    }
}

