/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.ButtonPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MessageBox
extends JDialog {
    Hashtable parameters = null;
    int screenWidth = 360;
    int screenHeight = 240;
    Font fontStandard = null;
    Font fontLarge = null;
    Color backColor = Color.black;
    Color textColor = Color.white;
    String title = "";
    String message = "";
    String button1Text = "";
    String button2Text = "";
    int value = -1;
    private JPanel buttonPanel;
    private JDialog mainDialog;
    private JPanel mainPanel;

    public MessageBox() {
        this.initComponents();
    }

    public void initialize(Hashtable parameters) {
        this.parameters = parameters;
        this.fontLarge = new Font("Arial", 1, 24);
        this.fontStandard = new Font("Arial", 0, 18);
        this.mainDialog.setBackground(Color.LIGHT_GRAY);
        Border lineBorder = BorderFactory.createLineBorder(this.textColor, 2);
        this.mainPanel.setBounds(0, 0, 360, 240);
        this.mainPanel.setBorder(lineBorder);
        this.mainPanel.setBackground(this.backColor);
        this.setVisible(false);
    }

    public int getValue() {
        return this.value;
    }

    public void setMessageBox(String message, String title, String button1Text, String button2Text) {
        this.title = title;
        this.message = message;
        this.button1Text = button1Text;
        this.button2Text = button2Text;
        this.loadFields();
        this.mainDialog.setLocationRelativeTo(this);
        this.mainDialog.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void loadFields() {
        Object button1 = null;
        Object button2 = null;
        this.mainPanel.removeAll();
        this.mainPanel.revalidate();
        if (this.title != null || !this.title.isEmpty()) {
            JLabel titleLabel = new JLabel();
            titleLabel.setBounds(2, (int)((double)this.screenHeight * 0.05), this.screenWidth - 4, (int)((double)this.screenHeight * 0.1));
            titleLabel.setText(this.title);
            titleLabel.setFont(this.fontLarge);
            titleLabel.setForeground(this.textColor);
            titleLabel.setHorizontalAlignment(0);
            titleLabel.setVerticalAlignment(0);
            this.mainPanel.add(titleLabel);
        }
        if (this.message != null || !this.message.isEmpty()) {
            JTextPane messagePane = new JTextPane();
            messagePane.setBounds(2, (int)((double)this.screenHeight * 0.2), this.screenWidth - 4, (int)((double)this.screenHeight * 0.4));
            messagePane.setText(this.message);
            messagePane.setFont(this.fontStandard);
            messagePane.setBackground(this.backColor);
            messagePane.setForeground(this.textColor);
            SimpleAttributeSet bSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(bSet, 1);
            StyledDocument doc = messagePane.getStyledDocument();
            doc.setParagraphAttributes(0, this.message.length(), bSet, false);
            this.mainPanel.add(messagePane);
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public ButtonPanel getButton(final int buttonId, String text) {
        Image imageUp = null;
        Image imageDown = null;
        int buttonWidth = (int)((double)this.buttonPanel.getWidth() * 0.3);
        int buttonHeight = (int)((double)this.buttonPanel.getHeight() * 0.5);
        ButtonPanel button = new ButtonPanel(this, buttonWidth, buttonHeight, imageUp, imageDown, this.fontLarge, text, Color.black);
        button.setBorder(null);
        button.setBackground(this.backColor);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MessageBox.this.value = buttonId;
                MessageBox.this.exitScreen();
            }
        });
        return button;
    }

    private void exitScreen() {
        this.mainDialog.dispose();
    }

    private void initComponents() {
        this.mainDialog = new JDialog();
        this.mainPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.mainDialog.setAlwaysOnTop(true);
        this.mainDialog.setModal(true);
        this.mainDialog.setUndecorated(true);
        this.mainDialog.getContentPane().setLayout(null);
        this.mainPanel.setBackground(new Color(204, 204, 255));
        this.mainPanel.setLayout(null);
        this.buttonPanel.setBackground(new Color(204, 204, 255));
        this.buttonPanel.setLayout(null);
        this.mainPanel.add(this.buttonPanel);
        this.buttonPanel.setBounds(0, 240, 400, 60);
        this.mainDialog.getContentPane().add(this.mainPanel);
        this.mainPanel.setBounds(0, 0, 400, 230);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setUndecorated(true);
        this.pack();
    }

    public static void main(String[] args) {
    }
}

