/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.LookAndFeel;
import AccuShiftPC.ScreenUtilities;
import AccuShiftPC.TimeClockBase;
import AccuShiftPC.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URI;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterName;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PrinterConfigScreen
extends JDialog {
    TimeClockBase parent;
    JComboBox printerNameBox = null;
    JComboBox printerDriverBox = null;
    JButton exitButton = null;
    JButton cancelButton = null;
    String configXml = "";
    Font font = null;
    int sourceX = 0;
    int sourceY = 0;
    int screenX = 0;
    int screenY = 0;
    int screenWide = 0;
    int screenHigh = 0;
    private JEditorPane htmlPane;
    private JPanel mainPanel;

    public PrinterConfigScreen(TimeClockBase parent, boolean modal, boolean editConfig) {
        super((Frame)new JFrame(), modal);
        this.initComponents();
        this.parent = parent;
        this.loadFields();
        this.pack();
    }

    public void displayScreen() {
        this.loadData();
        this.toFront();
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void loadData() {
        String orderPrinterXml = this.parent.getPrinterTypeNames(21);
        if (this.printerNameBox != null) {
            Vector printerList;
            this.printerNameBox.addItem("None");
            if (orderPrinterXml != null && !orderPrinterXml.isEmpty() && (printerList = Utility.getElementList("PrinterName", orderPrinterXml)) != null && !printerList.isEmpty()) {
                int len = printerList.size();
                for (int i = 0; i < len; ++i) {
                    String printerName = (String)printerList.get(i);
                    this.printerNameBox.addItem(printerName);
                }
            }
        }
        if (this.printerDriverBox != null) {
            this.printerDriverBox.addItem("");
            PrintService[] printerServices = PrinterJob.lookupPrintServices();
            for (int i = 0; i < printerServices.length; ++i) {
                String printerName = printerServices[i].getAttribute(PrinterName.class).getValue();
                this.printerDriverBox.addItem(printerName);
            }
        }
        this.configXml = this.parent.getPrinterConfiguration();
        if (this.configXml != null && !this.configXml.isEmpty()) {
            String text = Utility.getElement("PrinterName", this.configXml);
            if (text != null && !text.isEmpty() && this.printerNameBox != null) {
                this.printerNameBox.setSelectedItem(text);
            }
            if ((text = Utility.getElement("PrinterDriver", this.configXml)) != null && !text.isEmpty() && this.printerDriverBox != null) {
                this.printerDriverBox.setSelectedItem(text);
            }
        }
    }

    private boolean saveData() {
        String printerName = "<PrinterName>" + (String)this.printerNameBox.getSelectedItem() + "</PrinterName>";
        String printerDriver = "<PrinterDriver>" + (String)this.printerDriverBox.getSelectedItem() + "</PrinterDriver>";
        this.configXml = this.configXml != null && !this.configXml.isEmpty() && this.configXml.contains("<PrinterName>") ? Utility.replaceXmlBlock(this.configXml, "PrinterName", printerName) : printerName + "\n";
        this.configXml = this.configXml != null && !this.configXml.isEmpty() && this.configXml.contains("<PrinterDriver>") ? Utility.replaceXmlBlock(this.configXml, "PrinterDriver", printerDriver) : this.configXml + printerDriver + "\n";
        this.parent.savePrinterConfiguration(this.configXml);
        return true;
    }

    private void loadFields() {
        this.font = new Font("Arial", 1, 14);
        this.setFont(this.font);
        String xmlPath = ScreenUtilities.getTemplatePath("PrinterConfigScreen", "");
        String xml = Utility.getXml(xmlPath);
        String toolTipBackground = Utility.getElement("ToolTipBackground", xml);
        int red = Utility.getIntElement("Red", toolTipBackground);
        int green = Utility.getIntElement("Green", toolTipBackground);
        int blue = Utility.getIntElement("Blue", toolTipBackground);
        Color color = new Color(red, green, blue);
        try {
            UIManager.setLookAndFeel(new LookAndFeel(color));
        }
        catch (Exception ex) {
            ScreenUtilities.logScreenException(ex);
        }
        String borderXml = Utility.getElement("Border", xml);
        if (borderXml != null && borderXml.length() > 0) {
            red = Utility.getIntElement("Red", borderXml);
            green = Utility.getIntElement("Green", borderXml);
            blue = Utility.getIntElement("Blue", borderXml);
            Color borderColor = new Color(red, green, blue);
            int thick = Utility.getIntElement("Thickness", borderXml);
            this.mainPanel.setBorder(new LineBorder(borderColor, thick));
        }
        String screenXml = Utility.getElement("Screen", xml);
        String sizeXml = Utility.getElement("Size", screenXml);
        this.screenWide = Utility.getIntElement("Wide", sizeXml);
        this.screenHigh = Utility.getIntElement("High", sizeXml);
        String xText = Utility.getElement("X", sizeXml);
        String yText = Utility.getElement("Y", sizeXml);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        this.screenX = xText.compareToIgnoreCase("Center") == 0 ? (screenSize.width - this.screenWide) / 2 : Utility.getIntElement("X", sizeXml);
        this.screenY = yText.compareToIgnoreCase("Center") == 0 ? (screenSize.height - this.screenHigh) / 2 : Utility.getIntElement("Y", sizeXml);
        this.setBounds(this.screenX, this.screenY, this.screenWide, this.screenHigh);
        this.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.mainPanel.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.htmlPane.setBounds(0, 0, this.screenWide, this.screenHigh);
        this.htmlPane.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.htmlPane.setEditable(false);
        try {
            File file = new File(xmlPath);
            URI uri = file.toURI();
            this.htmlPane.setPage(uri.toURL());
            this.htmlPane.revalidate();
        }
        catch (Exception ex) {
            ScreenUtilities.logScreenException(ex);
        }
        Vector controlsXml = Utility.getElementList("Control", xml);
        int len = controlsXml.size();
        for (int i = 0; i < len; ++i) {
            String imageName;
            String thisControlXml = (String)controlsXml.get(i);
            String type = Utility.getElement("Type", thisControlXml);
            int xPos = Utility.getIntElement("X", thisControlXml);
            int yPos = Utility.getIntElement("Y", thisControlXml);
            int wide = Utility.getIntElement("Wide", thisControlXml);
            int high = Utility.getIntElement("High", thisControlXml);
            String fieldHtml = Utility.getElement("Html", thisControlXml);
            String toolTipText = Utility.getElement("ToolTip", thisControlXml);
            if (type.compareToIgnoreCase("ExitButton") == 0) {
                imageName = Utility.getElement("Image", thisControlXml);
                this.exitButton = imageName != null && imageName.length() > 0 ? new JButton(new ImageIcon(imageName)) : new JButton();
                this.htmlPane.add(this.exitButton);
                if (toolTipText != null) {
                    this.exitButton.setToolTipText(toolTipText);
                }
                this.exitButton.setFont(this.font);
                if (fieldHtml != null && fieldHtml.length() > 0) {
                    this.exitButton.setText("<html>" + fieldHtml + "</html>");
                }
                this.exitButton.setBounds(xPos, yPos, wide, high);
                this.exitButton.setContentAreaFilled(false);
                this.exitButton.setBorder(null);
                this.exitButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (PrinterConfigScreen.this.saveData()) {
                            PrinterConfigScreen.this.dispose();
                        }
                    }
                });
                continue;
            }
            if (type.compareToIgnoreCase("CancelButton") == 0) {
                imageName = Utility.getElement("Image", thisControlXml);
                this.cancelButton = imageName != null && imageName.length() > 0 ? new JButton(new ImageIcon(imageName)) : new JButton();
                this.htmlPane.add(this.cancelButton);
                if (toolTipText != null) {
                    this.cancelButton.setToolTipText(toolTipText);
                }
                this.cancelButton.setFont(this.font);
                if (fieldHtml != null && fieldHtml.length() > 0) {
                    this.cancelButton.setText("<html>" + fieldHtml + "</html>");
                }
                this.cancelButton.setBounds(xPos, yPos, wide, high);
                this.cancelButton.setContentAreaFilled(false);
                this.cancelButton.setBorder(null);
                this.cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PrinterConfigScreen.this.dispose();
                    }
                });
                continue;
            }
            if (type.compareToIgnoreCase("PrinterNameBox") == 0) {
                this.printerNameBox = new JComboBox();
                this.htmlPane.add(this.printerNameBox);
                if (toolTipText != null) {
                    this.printerNameBox.setToolTipText(toolTipText);
                }
                this.printerNameBox.setFont(this.font);
                this.printerNameBox.setBorder(null);
                this.printerNameBox.setBounds(xPos, yPos, wide, high);
                continue;
            }
            if (type.compareToIgnoreCase("PrinterDriverBox") == 0) {
                this.printerDriverBox = new JComboBox();
                this.htmlPane.add(this.printerDriverBox);
                if (toolTipText != null) {
                    this.printerDriverBox.setToolTipText(toolTipText);
                }
                this.printerDriverBox.setFont(this.font);
                this.printerDriverBox.setBorder(null);
                this.printerDriverBox.setBounds(xPos, yPos, wide, high);
                continue;
            }
            if (type.compareToIgnoreCase("Label") != 0) continue;
            JLabel label = new JLabel();
            this.htmlPane.add(label);
            if (toolTipText != null) {
                label.setToolTipText(toolTipText);
            }
            label.setFont(this.font);
            label.setBounds(xPos, yPos, wide, high);
            if (fieldHtml == null || fieldHtml.length() <= 0) continue;
            label.setText("<html>" + fieldHtml + "</html>");
        }
        this.invalidate();
        this.repaint();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.htmlPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.mainPanel.setPreferredSize(new Dimension(500, 550));
        this.mainPanel.setLayout(new BorderLayout());
        this.htmlPane.setEditable(false);
        this.htmlPane.setPreferredSize(new Dimension(400, 400));
        this.htmlPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PrinterConfigScreen.this.htmlPaneMousePressed(evt);
            }
        });
        this.htmlPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PrinterConfigScreen.this.htmlPaneMouseDragged(evt);
            }
        });
        this.mainPanel.add((Component)this.htmlPane, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void htmlPaneMouseDragged(MouseEvent evt) {
        int diffX = evt.getX();
        int diffY = evt.getY();
        Rectangle bounds = this.getBounds();
        bounds.x += diffX - this.sourceX;
        bounds.y += diffY - this.sourceY;
        this.setBounds(bounds);
    }

    private void htmlPaneMousePressed(MouseEvent evt) {
        this.sourceX = evt.getX();
        this.sourceY = evt.getY();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrinterConfigScreen dialog = new PrinterConfigScreen(null, true, false);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void abort() {
        this.dispose();
    }

    public class JNumberFieldLimit
    extends PlainDocument {
        private int limit;

        JNumberFieldLimit(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            if (str.length() == 1 && !str.matches("[0-9]")) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

