/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.Utility;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ScreenUtilities {
    static Hashtable images = new Hashtable();
    static Hashtable baseButtonImages = new Hashtable();

    public static String getTemplatePath(String name, String FSorRT) {
        String fileName = null;
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        try {
            fileName = userDir + pathSeparator + "Screens" + pathSeparator + name + FSorRT + ".tmpl";
            File logFile = new File(fileName);
            if (!logFile.exists() || !logFile.isFile()) {
                fileName = userDir + pathSeparator + "Screens" + pathSeparator + name + ".tmpl";
            }
        }
        catch (Exception ex) {
            ScreenUtilities.handleException(ex);
        }
        return fileName;
    }

    public static String getModuleConfigurationFile() {
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        String fileName = userDir + pathSeparator + "Screens" + pathSeparator + "ModuleConfigurations.xml";
        String config = Utility.getXml(fileName);
        return config;
    }

    public static String getManagementConfigFile() {
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        String fileName = userDir + pathSeparator + "AccuPOSManagement.cfg";
        String config = Utility.getXml(fileName);
        return config;
    }

    public static void updateManagementConfigFile(String fileContent) {
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        String fileName = userDir + pathSeparator + "AccuPOSManagement.cfg";
        try {
            Utility.writeXml(fileName, fileContent);
        }
        catch (IOException ex) {
            ScreenUtilities.handleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLog(String filename, String text) throws IOException {
        File outFile = new File(filename);
        try (Writer output = null;){
            output = new BufferedWriter(new FileWriter(outFile, true));
            output.append(text + " \r\n");
        }
    }

    public static void handleException(Exception e) {
        ScreenUtilities.logScreenException(e);
        e.printStackTrace();
        StackTraceElement[] traces = e.getStackTrace();
        int len = traces.length;
        String logText = e.getLocalizedMessage();
        for (int i = 0; i < len; ++i) {
            logText = logText + traces[i] + "\n";
        }
        JOptionPane.showMessageDialog(null, logText, "Exception", 0);
    }

    public static void logScreenException(Exception ex) {
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        String fileName = userDir + pathSeparator + "AccuPOSScreens.log";
        BufferedWriter output = null;
        try {
            File logFile = new File(fileName);
            if (!logFile.exists() || !logFile.isFile()) {
                logFile.createNewFile();
            } else if (logFile.length() > 64000L) {
                logFile.delete();
                logFile.createNewFile();
            }
            String logText = ex.getMessage() + "\r\n";
            StackTraceElement[] traces = ex.getStackTrace();
            for (int i = 0; i < traces.length; ++i) {
                logText = logText + traces[i] + "\r\n";
            }
            output = new BufferedWriter(new FileWriter(logFile, true));
            output.append(logText + "\r\n");
            ((Writer)output).close();
        }
        catch (IOException e) {
            Logger.getLogger(ScreenUtilities.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private static String getLiteralElement(String name, String xml) {
        String result = null;
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return null;
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return null;
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String getLiteralText(Hashtable literalsTable, String name) {
        String result = (String)literalsTable.get(name);
        return result == null ? name : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXml(String filename) {
        StringBuffer xml = new StringBuffer();
        FileInputStream fstream = null;
        try {
            String strLine;
            fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((strLine = br.readLine()) != null) {
                xml.append(strLine + "\n");
            }
        }
        catch (Exception ex) {
            ScreenUtilities.handleException(ex);
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException ex) {
                ScreenUtilities.handleException(ex);
            }
        }
        return xml.toString();
    }

    public static String replaceBraceTagText(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        int start = source.indexOf(startTag);
        int end = start + startTag.length();
        if (start < 0) {
            return source;
        }
        result.append(source.substring(0, start));
        result.append(replacement);
        result.append(source.substring(end));
        String reply = new String(result);
        int secondStart = source.indexOf(startTag);
        if (secondStart >= 0) {
            reply = ScreenUtilities.replaceBraceTagText(reply, tag, replacement);
        }
        return reply;
    }

    public static String replaceBraceTagBlock(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        String endTag = "{/" + tag + "}";
        int start = source.indexOf(startTag);
        if (start < 0) {
            return source;
        }
        int end = source.indexOf(endTag, start);
        result.append(source.substring(0, start));
        result.append(replacement);
        String endText = source.substring(end += endTag.length());
        result.append(endText);
        return new String(result);
    }

    public static String getBraceElement(String name, String xml, Hashtable parameters) {
        String result = "";
        String startTag = "{" + name;
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String parametersText = xml.substring(startPos + startTag.length(), startTagEnd);
        String[] pairs = parametersText.split(",");
        for (int i = 0; i < pairs.length; ++i) {
            String[] thisPair = pairs[i].split("=");
            if (thisPair.length <= 1) continue;
            parameters.put(thisPair[0].trim(), thisPair[1]);
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            result = xml.substring(++startTagEnd, endPos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrlText(String url) {
        String urlText = "";
        InputStream in = null;
        try {
            int byteRead;
            in = new URL(url).openStream();
            StringBuffer sb = new StringBuffer();
            byte[] buffer = new byte[10000];
            while ((byteRead = in.read(buffer)) != -1) {
                for (int i = 0; i < byteRead; ++i) {
                    sb.append((char)buffer[i]);
                }
            }
            urlText = sb.toString();
        }
        catch (Exception ex) {
            ScreenUtilities.handleException(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {
                ScreenUtilities.handleException(ex);
                return null;
            }
        }
        return urlText;
    }

    public static Image getButtonUpImage(String userDir, String pathSeparator, String imageName) {
        Image image = (Image)images.get(imageName);
        if (image == null) {
            try {
                File file = new File(userDir + pathSeparator + "Screens" + pathSeparator + "images" + pathSeparator + "buttons" + pathSeparator + imageName + "Up.png");
                if (file.exists()) {
                    image = ImageIO.read(file);
                    if (image != null) {
                        images.put(imageName, image);
                    }
                } else {
                    image = ScreenUtilities.readImageFromJar("posBtnBaseUp.png");
                }
            }
            catch (IOException e) {
                ScreenUtilities.handleException(e);
            }
        }
        return image;
    }

    public static Image getButtonDownImage(String userDir, String pathSeparator, String imageName) {
        Image image = (Image)images.get(imageName);
        if (image == null) {
            try {
                File file = new File(userDir + pathSeparator + "Screens" + pathSeparator + "images" + pathSeparator + "buttons" + pathSeparator + imageName + ".png");
                if (file.exists()) {
                    image = ImageIO.read(file);
                    if (image != null) {
                        images.put(imageName, image);
                    }
                } else {
                    image = ScreenUtilities.readImageFromJar("posBtnBaseDown.png");
                }
            }
            catch (IOException e) {
                ScreenUtilities.handleException(e);
            }
        }
        return image;
    }

    public static Image readImageFromJar(String imageName) {
        Image image = (Image)baseButtonImages.get(imageName);
        if (image == null) {
            try {
                String jarFileName = System.getProperty("user.dir") + System.getProperty("file.separator") + "AccuPOSManagement.jar";
                JarFile jarFile = new JarFile(jarFileName);
                JarEntry entry = jarFile.getJarEntry("AccuPOSManagement/" + imageName);
                InputStream input = jarFile.getInputStream(entry);
                image = ImageIO.read(input);
                baseButtonImages.put(imageName, image);
            }
            catch (Exception e) {
                ScreenUtilities.handleException(e);
            }
        }
        return image;
    }

    public static String translateUniversalSwipe(String scan) {
        StringBuilder universalData = new StringBuilder();
        try {
            int len = scan.length();
            for (int i = 0; i < len; i += 3) {
                String universalChar = scan.substring(i, i + 3);
                int universalInt = Integer.valueOf(universalChar);
                universalData.append((char)universalInt);
            }
            String data = universalData.toString();
            if (!data.startsWith("%") && !data.endsWith("?")) {
                universalData.setLength(0);
            }
        }
        catch (Exception ex) {
            universalData.setLength(0);
        }
        return universalData.toString();
    }

    public static String getEllipsistext(String text, FontMetrics fm, int maxWidth) {
        String displayText = text;
        int textWidth = fm.stringWidth(text);
        int textLength = text.length() - 4;
        while (textWidth > maxWidth) {
            displayText = text.substring(0, textLength) + "...";
            textWidth = fm.stringWidth(displayText);
            --textLength;
        }
        return displayText;
    }
}

