/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.LookAndFeel;
import AccuShiftPC.ScreenUtilities;
import AccuShiftPC.ServerConnection;
import AccuShiftPC.TimeClockBase;
import AccuShiftPC.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class ServerConfigScreen
extends JDialog {
    boolean editConfiguration = false;
    JTextField serverAddressEdit = null;
    JTextField serverPortEdit = null;
    String clientName = "";
    String serverLocation = "";
    String stationName = "";
    boolean debug = false;
    JButton exitButton = null;
    JButton cancelButton = null;
    JButton printerButton = null;
    Font font = null;
    int sourceX = 0;
    int sourceY = 0;
    int screenX = 0;
    int screenY = 0;
    int screenWide = 0;
    int screenHigh = 0;
    String userDir = "";
    String pathSeparator = "";
    TimeClockBase parent;
    private JEditorPane htmlPane;
    private JPanel mainPanel;

    public ServerConfigScreen(TimeClockBase parent, boolean modal, boolean editConfig) {
        super((Frame)new JFrame(), modal);
        this.initComponents();
        this.parent = parent;
        this.userDir = System.getProperty("user.dir");
        this.pathSeparator = System.getProperty("file.separator");
        this.editConfiguration = editConfig;
        this.loadFields();
        this.pack();
    }

    public void displayScreen() {
        if (this.editConfiguration) {
            String xml = Utility.getXml(this.userDir + this.pathSeparator + "AccuPOSServerConnection.cfg");
            if (xml != null) {
                ServerConnection thisConnection = new ServerConnection(xml);
                this.serverAddressEdit.setText(thisConnection.serverAddress);
                this.serverPortEdit.setText(thisConnection.serverPort);
                this.clientName = thisConnection.clientName;
                this.serverLocation = thisConnection.serverLocation;
                this.stationName = thisConnection.stationName;
                this.debug = thisConnection.debug;
            }
        }
        this.toFront();
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void loadData() {
    }

    private boolean saveData() {
        String serverAddress = this.serverAddressEdit.getText().trim();
        if (serverAddress.isEmpty()) {
            this.parent.showMessageBox(this.parent.getLiteral("Server Address is not defined."), this.parent.getLiteral("Server Address Error"), this.parent.getLiteral("OK"), null);
            return false;
        }
        String serverPort = this.serverPortEdit.getText().trim();
        if (serverPort.isEmpty()) {
            this.parent.showMessageBox(this.parent.getLiteral("Server Port is not defined."), this.parent.getLiteral("Server Port Error"), this.parent.getLiteral("OK"), null);
            return false;
        }
        ServerConnection thisConnection = new ServerConnection();
        thisConnection.serverAddress = serverAddress;
        thisConnection.serverPort = serverPort;
        thisConnection.clientName = this.clientName;
        thisConnection.serverLocation = this.serverLocation;
        thisConnection.stationName = this.stationName;
        thisConnection.debug = this.debug;
        try {
            Utility.writeXml(this.userDir + this.pathSeparator + "AccuPOSServerConnection.cfg", thisConnection.toXml());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void loadFields() {
        this.font = new Font("Arial", 1, 14);
        this.setFont(this.font);
        String xmlPath = ScreenUtilities.getTemplatePath("AccuShiftPCServerConfigScreen", "");
        String xml = Utility.getXml(xmlPath);
        String toolTipBackground = Utility.getElement("ToolTipBackground", xml);
        int red = Utility.getIntElement("Red", toolTipBackground);
        int green = Utility.getIntElement("Green", toolTipBackground);
        int blue = Utility.getIntElement("Blue", toolTipBackground);
        Color color = new Color(red, green, blue);
        try {
            UIManager.setLookAndFeel(new LookAndFeel(color));
        }
        catch (Exception ex) {
            ScreenUtilities.logScreenException(ex);
        }
        String borderXml = Utility.getElement("Border", xml);
        if (borderXml != null && borderXml.length() > 0) {
            red = Utility.getIntElement("Red", borderXml);
            green = Utility.getIntElement("Green", borderXml);
            blue = Utility.getIntElement("Blue", borderXml);
            Color borderColor = new Color(red, green, blue);
            int thick = Utility.getIntElement("Thickness", borderXml);
            this.mainPanel.setBorder(new LineBorder(borderColor, thick));
        }
        String screenXml = Utility.getElement("Screen", xml);
        String sizeXml = Utility.getElement("Size", screenXml);
        this.screenWide = Utility.getIntElement("Wide", sizeXml);
        this.screenHigh = Utility.getIntElement("High", sizeXml);
        String xText = Utility.getElement("X", sizeXml);
        String yText = Utility.getElement("Y", sizeXml);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        this.screenX = xText.compareToIgnoreCase("Center") == 0 ? (screenSize.width - this.screenWide) / 2 : Utility.getIntElement("X", sizeXml);
        this.screenY = yText.compareToIgnoreCase("Center") == 0 ? (screenSize.height - this.screenHigh) / 2 : Utility.getIntElement("Y", sizeXml);
        this.setBounds(this.screenX, this.screenY, this.screenWide, this.screenHigh);
        this.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.mainPanel.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.htmlPane.setBounds(0, 0, this.screenWide, this.screenHigh);
        this.htmlPane.setPreferredSize(new Dimension(this.screenWide, this.screenHigh));
        this.htmlPane.setEditable(false);
        try {
            File file = new File(xmlPath);
            URI uri = file.toURI();
            this.htmlPane.setPage(uri.toURL());
            this.htmlPane.revalidate();
        }
        catch (Exception ex) {
            ScreenUtilities.logScreenException(ex);
        }
        Vector controlsXml = Utility.getElementList("Control", xml);
        int len = controlsXml.size();
        for (int i = 0; i < len; ++i) {
            String imageName;
            String thisControlXml = (String)controlsXml.get(i);
            String type = Utility.getElement("Type", thisControlXml);
            int xPos = Utility.getIntElement("X", thisControlXml);
            int yPos = Utility.getIntElement("Y", thisControlXml);
            int wide = Utility.getIntElement("Wide", thisControlXml);
            int high = Utility.getIntElement("High", thisControlXml);
            String fieldHtml = Utility.getElement("Html", thisControlXml);
            String toolTipText = Utility.getElement("ToolTip", thisControlXml);
            if (type.compareToIgnoreCase("ExitButton") == 0) {
                imageName = Utility.getElement("Image", thisControlXml);
                this.exitButton = imageName != null && imageName.length() > 0 ? new JButton(new ImageIcon(imageName)) : new JButton();
                this.htmlPane.add(this.exitButton);
                if (toolTipText != null) {
                    this.exitButton.setToolTipText(toolTipText);
                }
                this.exitButton.setFont(this.font);
                if (fieldHtml != null && fieldHtml.length() > 0) {
                    this.exitButton.setText("<html>" + fieldHtml + "</html>");
                }
                this.exitButton.setBounds(xPos, yPos, wide, high);
                this.exitButton.setContentAreaFilled(false);
                this.exitButton.setBorder(null);
                this.exitButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ServerConfigScreen.this.saveData()) {
                            ServerConfigScreen.this.dispose();
                        }
                    }
                });
                continue;
            }
            if (type.compareToIgnoreCase("CancelButton") == 0) {
                imageName = Utility.getElement("Image", thisControlXml);
                this.cancelButton = imageName != null && imageName.length() > 0 ? new JButton(new ImageIcon(imageName)) : new JButton();
                this.htmlPane.add(this.cancelButton);
                if (toolTipText != null) {
                    this.cancelButton.setToolTipText(toolTipText);
                }
                this.cancelButton.setFont(this.font);
                if (fieldHtml != null && fieldHtml.length() > 0) {
                    this.cancelButton.setText("<html>" + fieldHtml + "</html>");
                }
                this.cancelButton.setBounds(xPos, yPos, wide, high);
                this.cancelButton.setContentAreaFilled(false);
                this.cancelButton.setBorder(null);
                this.cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ServerConfigScreen.this.editConfiguration) {
                            ServerConfigScreen.this.dispose();
                        } else {
                            System.exit(0);
                        }
                    }
                });
                continue;
            }
            if (type.compareToIgnoreCase("PrinterButton") == 0) {
                imageName = Utility.getElement("Image", thisControlXml);
                this.printerButton = imageName != null && imageName.length() > 0 ? new JButton(new ImageIcon(imageName)) : new JButton();
                this.htmlPane.add(this.printerButton);
                if (toolTipText != null) {
                    this.printerButton.setToolTipText(toolTipText);
                }
                this.printerButton.setFont(this.font);
                if (fieldHtml != null && fieldHtml.length() > 0) {
                    this.printerButton.setText("<html>" + fieldHtml + "</html>");
                }
                this.printerButton.setBounds(xPos, yPos, wide, high);
                this.printerButton.setContentAreaFilled(false);
                this.printerButton.setBorder(null);
                this.printerButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ServerConfigScreen.this.dispose();
                        ServerConfigScreen.this.parent.showPrinterConfiguration();
                    }
                });
                continue;
            }
            if (type.compareToIgnoreCase("ServerAddressEdit") == 0) {
                this.serverAddressEdit = new JTextField();
                this.serverAddressEdit.setHorizontalAlignment(2);
                this.htmlPane.add(this.serverAddressEdit);
                if (toolTipText != null) {
                    this.serverAddressEdit.setToolTipText(toolTipText);
                }
                this.serverAddressEdit.setFont(this.font);
                this.serverAddressEdit.setBorder(null);
                this.serverAddressEdit.setBounds(xPos, yPos, wide, high);
                continue;
            }
            if (type.compareToIgnoreCase("ServerPortEdit") == 0) {
                this.serverPortEdit = new JTextField();
                this.serverPortEdit.setHorizontalAlignment(2);
                this.htmlPane.add(this.serverPortEdit);
                if (toolTipText != null) {
                    this.serverPortEdit.setToolTipText(toolTipText);
                }
                this.serverPortEdit.setFont(this.font);
                this.serverPortEdit.setBorder(null);
                this.serverPortEdit.setBounds(xPos, yPos, wide, high);
                continue;
            }
            if (type.compareToIgnoreCase("Label") != 0) continue;
            JLabel label = new JLabel();
            this.htmlPane.add(label);
            if (toolTipText != null) {
                label.setToolTipText(toolTipText);
            }
            label.setFont(this.font);
            label.setBounds(xPos, yPos, wide, high);
            if (fieldHtml == null || fieldHtml.length() <= 0) continue;
            label.setText("<html>" + fieldHtml + "</html>");
        }
        this.invalidate();
        this.repaint();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.htmlPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.mainPanel.setPreferredSize(new Dimension(500, 550));
        this.mainPanel.setLayout(new BorderLayout());
        this.htmlPane.setEditable(false);
        this.htmlPane.setPreferredSize(new Dimension(400, 400));
        this.htmlPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ServerConfigScreen.this.htmlPaneMousePressed(evt);
            }
        });
        this.htmlPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ServerConfigScreen.this.htmlPaneMouseDragged(evt);
            }
        });
        this.mainPanel.add((Component)this.htmlPane, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void htmlPaneMouseDragged(MouseEvent evt) {
        int diffX = evt.getX();
        int diffY = evt.getY();
        Rectangle bounds = this.getBounds();
        bounds.x += diffX - this.sourceX;
        bounds.y += diffY - this.sourceY;
        this.setBounds(bounds);
    }

    private void htmlPaneMousePressed(MouseEvent evt) {
        this.sourceX = evt.getX();
        this.sourceY = evt.getY();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerConfigScreen dialog = new ServerConfigScreen(null, true, false);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void abort() {
        this.dispose();
    }
}

