/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftDataObjects.Employee;
import AccuShiftPC.ServerConnection;
import AccuShiftPC.SocketListener;
import AccuShiftPC.TimeClockBase;
import AccuShiftPC.Utility;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketConnector {
    TimeClockBase parent = null;
    int localPort = 0;
    int serverPort = 0;
    String serverHost = "";
    Thread listenerThread = null;
    boolean secure = true;

    public SocketConnector(TimeClockBase parentModule, ServerConnection serverConnection) {
        if (this.secure) {
            String userDir = System.getProperty("user.dir");
            String pathSeparator = System.getProperty("file.separator");
            Properties systemProps = System.getProperties();
            systemProps.put("javax.net.ssl.keyStore", userDir + pathSeparator + "client.jks");
            systemProps.put("javax.net.ssl.keyStorePassword", "abouttime");
            systemProps.put("javax.net.ssl.trustStore", userDir + pathSeparator + "clienttruststore.jks");
            systemProps.put("javax.net.ssl.trustStorePassword", "abouttime");
            System.setProperties(systemProps);
        }
        this.parent = parentModule;
        this.initialize(serverConnection);
    }

    public Socket getConnection(int timeout) throws Exception {
        int trys = 3;
        Socket socket = null;
        while (socket == null && trys > 0) {
            try {
                if (this.secure) {
                    SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    socket = (SSLSocket)socketFactory.createSocket();
                } else {
                    SocketFactory sslsocketfactory = SocketFactory.getDefault();
                    socket = sslsocketfactory.createSocket();
                }
            }
            catch (Exception iOException) {
                return null;
            }
            if (socket != null) {
                socket.connect(new InetSocketAddress(this.serverHost, this.serverPort), timeout);
                boolean down = socket.isInputShutdown();
                if (!down) continue;
                System.out.println("down");
                return null;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                this.raiseException(e);
            }
            --trys;
        }
        return socket;
    }

    public void raiseException(Exception e) {
        this.parent.handleException(e);
    }

    public void initialize(ServerConnection serverConnection) {
        String text = serverConnection.serverPort;
        if ((text = text.trim()) == null || text.length() == 0) {
            this.parent.handleException(new RuntimeException("Missing SERVER PORT for AccuServerSocketConnector"));
        } else {
            try {
                this.serverPort = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                this.parent.handleException(ex);
            }
        }
        text = serverConnection.serverAddress;
        text = text.trim();
        if (text == null || text.length() == 0) {
            this.parent.handleException(new RuntimeException("Missing SERVER HOST for AccuServerSocketConnector"));
        } else {
            this.serverHost = text;
        }
        System.out.println("Server Socket Port set to " + this.serverPort);
        System.out.println("Server Socket Host set to " + this.serverHost);
        this.parent.setServerConnector(this);
    }

    public void listen(int port) {
        try {
            SocketListener posListener = new SocketListener(this, port);
            this.listenerThread = new Thread(posListener);
            this.listenerThread.start();
        }
        catch (Exception e) {
            this.parent.handleException(e);
        }
    }

    public void close() {
        if (this.listenerThread != null && this.listenerThread.isAlive()) {
            this.listenerThread.interrupt();
        }
    }

    public void setServerConnector() {
        this.parent.setServerConnector(this);
    }

    public String pingServer() {
        String reply = "";
        String request = "<POSServerRequest><Action>Ping</Action></POSServerRequest>";
        Utility utility = new Utility();
        try {
            reply = utility.sendRequest(this.getConnection(2000), request);
        }
        catch (Exception ex) {
            reply = "<Error>" + Utility.getExceptionText(ex) + "<Error>";
        }
        return reply;
    }

    public String getClientConfig(String deviceId) {
        String reply = "";
        Utility utility = new Utility();
        String request = "<POSServerRequest><Action>GetAccuShiftClientConfig</Action><DeviceId>" + deviceId + "</DeviceId></POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(2000), request);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String getEmployeeInfo(String employeeId) {
        String reply = "";
        Utility utility = new Utility();
        String requestXml = "<POSServerRequest><Action>GetEmployeeInfo</Action><EmployeeId>" + employeeId + "</EmployeeId>" + "</POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(2000), requestXml);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        return reply;
    }

    public boolean isClockedIntoBreak(String employeeId) {
        String reply = "";
        Utility utility = new Utility();
        String requestXml = "<POSServerRequest><Action>IsClockedIntoBreak</Action><EmployeeId>" + employeeId + "</EmployeeId>" + "</POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(0), requestXml);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        boolean result = Utility.getBooleanElement("ClockIntoBreak", reply);
        return result;
    }

    public String setEmployeeClockIn(Employee employee, String loginId, int breakId) {
        String reply = "";
        Utility utility = new Utility();
        String requestXml = "<POSServerRequest><Action>EmployeeClockIn</Action><EmployeeId>" + employee.id + "</EmployeeId>" + "<LoginId>" + loginId + "</LoginId>" + "<PayLevelNumber>" + employee.payLevelNumber + "</PayLevelNumber>" + "<BreakId>" + breakId + "</BreakId>" + "</POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(2000), requestXml);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String setEmployeeClockOut(Employee employee, String loginId) {
        String reply = "";
        Utility utility = new Utility();
        String requestXml = "<POSServerRequest><Action>EmployeeClockOut</Action><EmployeeId>" + employee.id + "</EmployeeId>" + "<LoginId>" + loginId + "</LoginId>" + "</POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(2000), requestXml);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String getPrinterTypeNames(int printerType) {
        String reply = "";
        StringBuilder request = new StringBuilder();
        request.append("<POSServerRequest>");
        request.append("<Action>GetPrinterTypeNames</Action>");
        request.append("<PrinterType>" + printerType + "</PrinterType>");
        request.append("<POSType>PC</POSType>");
        request.append("</POSServerRequest>");
        Utility utility = new Utility();
        try {
            reply = utility.sendRequest(this.getConnection(0), request.toString());
        }
        catch (Exception ex) {
            reply = "<Error>" + Utility.getExceptionText(ex) + "<Error>";
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String getBreaks() {
        String reply = "";
        StringBuilder request = new StringBuilder();
        request.append("<POSServerRequest>");
        request.append("<Action>GetBreaks</Action>");
        request.append("</POSServerRequest>");
        Utility utility = new Utility();
        try {
            reply = utility.sendRequest(this.getConnection(0), request.toString());
        }
        catch (Exception ex) {
            reply = "<Error>" + Utility.getExceptionText(ex) + "<Error>";
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String getClockInPayLevel(Employee employee) {
        String reply = "";
        Utility utility = new Utility();
        String requestXml = "<POSServerRequest><Action>GetClockInPayLevel</Action><EmployeeId>" + employee.id + "</EmployeeId>" + "</POSServerRequest>\r\n";
        try {
            reply = utility.sendRequest(this.getConnection(2000), requestXml);
        }
        catch (Exception ex) {
            this.parent.handleException(ex);
        }
        return reply;
    }

    public String getLiterals() {
        Utility utility = new Utility();
        String request = "<POSServerRequest><Action>GetLiterals</Action></POSServerRequest>\r\n";
        int retrys = 3;
        String reply = null;
        while (reply == null && retrys > 0) {
            try {
                reply = utility.sendRequest(this.getConnection(0), request);
            }
            catch (Exception ex) {
                this.parent.handleException(ex);
            }
            if (reply != null) continue;
            --retrys;
        }
        return reply;
    }
}

