/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.PrintData;
import AccuShiftPC.ScreenUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;

public class TicketPrinter
implements Printable {
    Vector printList = null;
    int paperwidth = 0;

    @Override
    public int print(Graphics gx, PageFormat pf, int page) throws PrinterException {
        int printHeight = 0;
        if (page > 0) {
            return 1;
        }
        Graphics2D g = (Graphics2D)gx;
        if (this.printList != null) {
            int len = this.printList.size();
            for (int i = 0; i < len; ++i) {
                PrintData printData = (PrintData)this.printList.get(i);
                if (printData.image != null) {
                    printHeight += printData.height;
                }
                if (printData.text.length() <= 0) continue;
                FontMetrics metrics = g.getFontMetrics(printData.font);
                int lineItemHeight = metrics.getHeight();
                printHeight += lineItemHeight;
            }
            Paper paper = pf.getPaper();
            paper.setSize(500.0, printHeight);
            pf.setPaper(paper);
            g.translate(pf.getImageableX(), pf.getImageableY());
            g.setColor(Color.black);
            for (int i = 0; i < len; ++i) {
                PrintData printData = (PrintData)this.printList.get(i);
                if (printData.image != null) {
                    g.drawImage(printData.image, printData.left, printData.top, printData.width, printData.height, null);
                }
                if (printData.text.length() <= 0) continue;
                this.drawText(g, pf, printData);
            }
        }
        return 0;
    }

    public void printData(String driverName, byte[] byteArray) {
        PrintService printService = null;
        PrintService[] services = PrinterJob.lookupPrintServices();
        int len = services.length;
        for (int i = 0; i < len; ++i) {
            if (!services[i].getName().equalsIgnoreCase(driverName)) continue;
            printService = services[i];
            break;
        }
        if (printService != null) {
            try {
                DocPrintJob printJob = printService.createPrintJob();
                DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
                SimpleDoc doc = new SimpleDoc(byteArray, flavor, null);
                printJob.print(doc, null);
            }
            catch (Exception ex) {
                ScreenUtilities.handleException(ex);
            }
        }
    }

    public void printData(String driverName, Vector printList) {
        block4: {
            this.printList = printList;
            PrintService printService = null;
            PrintService[] services = PrinterJob.lookupPrintServices();
            int len = services.length;
            for (int i = 0; i < len; ++i) {
                if (!services[i].getName().equalsIgnoreCase(driverName)) continue;
                printService = services[i];
                break;
            }
            if (printService != null) {
                try {
                    DocPrintJob printJob = printService.createPrintJob();
                    DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                    MediaPrintableArea printArea = new MediaPrintableArea(0, 0, 8, 600, 25400);
                    HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                    attributes.add(OrientationRequested.PORTRAIT);
                    attributes.add(printArea);
                    attributes.add(new JobName("Receipt", null));
                    SimpleDoc doc = new SimpleDoc(this, flavor, null);
                    printJob.print(doc, attributes);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("PrinterAbortException")) break block4;
                    ScreenUtilities.handleException(ex);
                }
            }
        }
    }

    private void drawText(Graphics2D g, PageFormat pf, PrintData printData) {
        int xOffset = 0;
        g.setFont(printData.font);
        FontMetrics metrics = g.getFontMetrics(printData.font);
        int height = metrics.getHeight();
        int width = metrics.stringWidth(printData.text);
        if (printData.align.equalsIgnoreCase("Center")) {
            xOffset = (this.paperwidth - width) / 2;
        } else if (printData.align.equalsIgnoreCase("Left")) {
            xOffset = printData.left;
        } else if (printData.align.equalsIgnoreCase("Right")) {
            xOffset = printData.left - width;
        } else if (printData.align.equalsIgnoreCase("Decimal")) {
            int offset = printData.text.indexOf(46);
            String dollars = printData.text.substring(0, offset);
            int dollarWidth = metrics.stringWidth(dollars);
            xOffset = printData.left - dollarWidth;
        } else {
            xOffset = 5;
        }
        if (printData.align.equalsIgnoreCase("Center") && width > this.paperwidth) {
            String[] lines = this.wrapText(printData.text, g, printData.font, this.paperwidth - 10);
            for (int i = 0; i < lines.length; ++i) {
                width = metrics.stringWidth(lines[i]);
                xOffset = (this.paperwidth - width) / 2;
                g.drawString(lines[i], xOffset, printData.top + i * height);
            }
        } else {
            String printText = printData.text;
            if (printData.width > 0 && printText.length() > 1) {
                printText = ScreenUtilities.getEllipsistext(printData.text, metrics, printData.width);
            }
            g.drawString(printText, xOffset, printData.top);
        }
        g.dispose();
    }

    public String[] wrapText(String text, Graphics g, Font font, double width) {
        ArrayList<String> result = new ArrayList<String>();
        FontMetrics metrics = g.getFontMetrics(font);
        float lineHeight = 0.0f;
        int len = text.length();
        String line = "";
        String word = "";
        String temp = "";
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            temp = word + c;
            Rectangle2D rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > (double)lineHeight) {
                lineHeight = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                result.add(word);
                word = "";
            }
            word = word + c;
            temp = line + word;
            rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > (double)lineHeight) {
                lineHeight = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                if (line.length() > 0) {
                    result.add(line);
                }
                line = "";
            } else if (c == '\n') {
                line = line + word;
                word = "";
                result.add(line);
                line = "";
            }
            if (c != ' ') continue;
            line = line + word;
            word = "";
        }
        if (word.length() > 0) {
            line = line + word;
        }
        if (line.length() > 0) {
            result.add(line);
        }
        len = result.size();
        String[] returnValue = new String[len];
        for (int i = 0; i < len; ++i) {
            returnValue[i] = (String)result.get(i);
        }
        return returnValue;
    }
}

