/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftDataObjects.BreakInfo;
import AccuShiftDataObjects.Employee;
import AccuShiftPC.ButtonPanel;
import AccuShiftPC.PrinterConfigScreen;
import AccuShiftPC.ServerConfigScreen;
import AccuShiftPC.ServerConnection;
import AccuShiftPC.SocketConnector;
import AccuShiftPC.TimeClockBase;
import AccuShiftPC.TimeClockPrinter;
import AccuShiftPC.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TimeClockFrame
extends JDialog
implements TimeClockBase {
    Timer timer;
    String userDir;
    String pathSeparator = "";
    Employee currentEmployee = null;
    String selectedPayType = null;
    boolean autoQuit = false;
    boolean keepRunning = false;
    SocketConnector conn = null;
    ArrayList payLevels = null;
    SimpleDateFormat timeFormat = null;
    int messageDisplayTime = 3000;
    String printerDriver = "";
    TimeClockPrinter timeClockPrinter = null;
    ArrayList breaksList = null;
    boolean clockingOut = false;
    Font font = null;
    JLabel timeLabel = null;
    JPasswordField passCodeEdit = null;
    JPanel selectBorderPanel = null;
    JPanel selectPanel = null;
    JScrollPane buttonScrollPane = null;
    JLabel selectLabel = null;
    ButtonPanel selectScrollUpBtn = null;
    ButtonPanel selectScrollDownBtn = null;
    Color backColor = null;
    Font fontLarge = null;
    Font fontStandard = null;
    Hashtable literalsTable = null;
    int confirmationValue = 0;
    JPanel keyPadPanel = null;
    JPanel keyPanel = null;
    JPanel clockInPanel = null;
    JPanel clockOutPanel = null;
    private JPanel buttonPanel;
    private JPanel mainPanel;
    private JDialog messageDialog;
    private JPanel messagePanel;

    public TimeClockFrame(boolean autoQuit, boolean keepRunning) {
        String printerName;
        this.autoQuit = autoQuit;
        this.keepRunning = keepRunning;
        this.initComponents();
        this.userDir = System.getProperty("user.dir");
        this.pathSeparator = System.getProperty("file.separator");
        this.setTitle("AccuShiftPC - Version " + this.getVersion() + ", copyright 2020 by AccuPOS Point Of Sale, all rights reserved");
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new SetTime(), 1000L, 1000L);
        this.timeFormat = new SimpleDateFormat("h:mm a");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int left = (screen.width - this.getWidth()) / 2;
        int down = (screen.height - this.getHeight()) / 3;
        this.setBounds(left, down, this.getWidth(), this.getHeight());
        String printerXml = this.getPrinterConfiguration();
        if (printerXml != null && !printerXml.isEmpty() && (printerName = Utility.getElement("PrinterName", printerXml)) != null && !printerName.equalsIgnoreCase("None")) {
            this.printerDriver = Utility.getElement("PrinterDriver", printerXml);
            this.timeClockPrinter = new TimeClockPrinter(this, this.printerDriver);
        }
        SocketConnector connector = null;
        ServerConnection serverConnection = this.getServerConfig();
        if (serverConnection != null) {
            connector = new SocketConnector(this, serverConnection);
            if (connector != null) {
                String result = connector.pingServer();
                if (result == null || result != null && result.contains("Error")) {
                    JOptionPane.showMessageDialog(this, "Server Connection Failed \n\nCheck server address and port\n\n", "Server Connection", 0);
                    System.exit(0);
                }
                this.literalsTable = Utility.getLiteralsTable(connector);
            }
        } else {
            this.showConfiguration();
        }
        this.loadFields();
        this.passCodeEdit.requestFocusInWindow();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                TimeClockFrame.this.closeWindow();
            }
        });
    }

    private void loadFields() {
        this.font = new Font("Arial", 1, 36);
        this.backColor = new Color(75, 75, 75);
        this.timeLabel = new JLabel();
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setFont(this.font);
        this.timeLabel.setBackground(this.backColor);
        this.timeLabel.setForeground(Color.white);
        this.timeLabel.setOpaque(true);
        this.timeLabel.setBounds(12, (int)((double)this.getHeight() * 0.075), (int)((double)this.getWidth() * 0.5) - 24, (int)((double)this.getHeight() * 0.05));
        this.mainPanel.add(this.timeLabel);
        this.passCodeEdit = new JPasswordField();
        this.passCodeEdit.setHorizontalAlignment(0);
        this.passCodeEdit.setFont(this.font);
        this.passCodeEdit.setEchoChar('*');
        this.passCodeEdit.setBorder(null);
        this.passCodeEdit.setForeground(Color.black);
        this.passCodeEdit.setBackground(Color.white);
        this.passCodeEdit.setBounds((int)((double)this.getWidth() * 0.125), (int)((double)this.getHeight() * 0.15), (int)((double)this.getWidth() * 0.25), (int)((double)this.getHeight() * 0.05));
        this.mainPanel.add(this.passCodeEdit);
        this.passCodeEdit.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                boolean alt = evt.isAltDown();
                boolean control = evt.isControlDown();
                int thisCode = evt.getKeyCode();
                if (control && alt && thisCode == 83) {
                    TimeClockFrame.this.showConfiguration();
                }
                if (control && alt && thisCode == 67) {
                    TimeClockFrame.this.showConfiguration();
                }
                if (control && alt && thisCode == 80) {
                    TimeClockFrame.this.showPrinterConfiguration();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.selectLabel = new JLabel();
        this.selectLabel.setText(this.getLiteral("Clock IN as:"));
        this.selectLabel.setHorizontalAlignment(0);
        this.selectLabel.setFont(this.font);
        this.selectLabel.setBackground(this.backColor);
        this.selectLabel.setForeground(Color.white);
        this.selectLabel.setVisible(false);
        this.selectLabel.setBounds(0, (int)((double)this.getHeight() * 0.3), (int)((double)this.getWidth() * 0.5), (int)((double)this.getHeight() * 0.05));
        this.mainPanel.add(this.selectLabel);
        this.selectBorderPanel = new JPanel();
        this.selectBorderPanel.setBorder(new LineBorder(new Color(200, 250, 250)));
        this.selectBorderPanel.setLayout(new BorderLayout());
        this.selectBorderPanel.setBackground(this.backColor);
        this.selectBorderPanel.setVisible(false);
        this.selectBorderPanel.setBounds(0, (int)((double)this.getHeight() * 0.36), (int)((double)this.getWidth() * 0.5), (int)((double)this.getHeight() * 0.475));
        this.mainPanel.add(this.selectBorderPanel);
        this.selectPanel = new JPanel();
        this.selectPanel.setBackground(this.backColor);
        this.selectPanel.setLayout(null);
        this.selectPanel.setBorder(null);
        this.selectPanel.setBounds(0, (int)((double)this.getHeight() * 0.36), (int)((double)this.getWidth() * 0.5), (int)((double)this.getHeight() * 0.475));
        this.buttonScrollPane = new JScrollPane(this.selectPanel);
        this.buttonScrollPane.setBounds(0, 0, this.selectPanel.getWidth(), this.selectPanel.getHeight());
        this.buttonScrollPane.setBorder(null);
        this.buttonScrollPane.setVerticalScrollBarPolicy(21);
        this.buttonScrollPane.setHorizontalScrollBarPolicy(31);
        this.selectBorderPanel.add(this.buttonScrollPane);
        final int btnHeight = (int)((double)this.getHeight() * 0.075);
        int btnWidth = (int)((double)this.getWidth() * 0.2);
        int btnLeft = (int)((double)this.getWidth() * 0.05);
        Image img = Utility.getImage("scroll-up.png");
        this.selectScrollUpBtn = new ButtonPanel(this, btnHeight, btnWidth, img, this.font, "", Color.black);
        this.mainPanel.add(this.selectScrollUpBtn);
        this.selectScrollUpBtn.setBorder(null);
        this.selectScrollUpBtn.setBackground(this.backColor);
        this.selectScrollUpBtn.setVisible(false);
        this.selectScrollUpBtn.setBounds(btnLeft, this.getHeight() - btnHeight * 2, btnWidth, btnHeight);
        this.selectScrollUpBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Rectangle viewRectangle = TimeClockFrame.this.buttonScrollPane.getViewport().getViewRect();
                int top = viewRectangle.y;
                TimeClockFrame.this.selectPanel.scrollRectToVisible(new Rectangle(0, top - btnHeight * 2, 10, 5));
            }
        });
        img = Utility.getImage("scroll-down.png");
        this.selectScrollDownBtn = new ButtonPanel(this, btnHeight, btnWidth, img, this.font, "", Color.black);
        this.mainPanel.add(this.selectScrollDownBtn);
        this.selectScrollDownBtn.setBorder(null);
        this.selectScrollDownBtn.setBackground(this.backColor);
        this.selectScrollDownBtn.setVisible(false);
        this.selectScrollDownBtn.setBounds(btnLeft + btnWidth + 10, this.getHeight() - btnHeight * 2, btnWidth, btnHeight);
        this.selectScrollDownBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Rectangle viewRectangle = TimeClockFrame.this.buttonScrollPane.getViewport().getViewRect();
                int bottom = viewRectangle.y + viewRectangle.height;
                TimeClockFrame.this.selectPanel.scrollRectToVisible(new Rectangle(0, bottom + btnHeight * 2, 10, 10));
            }
        });
        this.keyPadPanel = new JPanel();
        this.keyPadPanel.setBackground(Color.black);
        this.keyPadPanel.setOpaque(true);
        this.keyPadPanel.setLayout(null);
        this.keyPadPanel.setBounds((int)((double)this.getWidth() * 0.5) - 10, 1, (int)((double)this.getWidth() * 0.5) - 8, (int)((double)this.getHeight() * 0.835));
        this.mainPanel.add(this.keyPadPanel);
        int margin = 15;
        this.clockInPanel = new JPanel();
        this.clockInPanel.setLayout(null);
        this.clockInPanel.setOpaque(true);
        this.clockInPanel.setBackground(new Color(0, 200, 100));
        this.clockInPanel.setBorder(new SoftBevelBorder(0));
        this.clockInPanel.setBounds(margin, margin, (int)((double)this.getWidth() * 0.25) - margin - 1, (int)((double)this.keyPadPanel.getHeight() * 0.15));
        this.clockInPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimeClockFrame.this.clockIn();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TimeClockFrame.this.clockInPanel.setBackground(new Color(200, 255, 200));
                TimeClockFrame.this.clockInPanel.revalidate();
                TimeClockFrame.this.clockInPanel.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TimeClockFrame.this.clockInPanel.setBackground(new Color(0, 200, 100));
                TimeClockFrame.this.clockInPanel.revalidate();
                TimeClockFrame.this.clockInPanel.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.keyPadPanel.add(this.clockInPanel);
        JLabel clockLabel = new JLabel();
        clockLabel.setText(this.getLiteral("clock"));
        clockLabel.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 24);
        clockLabel.setFont(this.font);
        clockLabel.setForeground(Color.black);
        clockLabel.setBounds(0, 0, this.clockInPanel.getWidth(), (int)((double)this.clockInPanel.getHeight() * 0.5));
        this.clockInPanel.add(clockLabel);
        JLabel inLabel = new JLabel();
        inLabel.setText(this.getLiteral("IN"));
        inLabel.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 48);
        inLabel.setFont(this.font);
        inLabel.setForeground(Color.black);
        inLabel.setBounds(0, (int)((double)this.clockInPanel.getHeight() * 0.5), this.clockInPanel.getWidth(), (int)((double)this.clockInPanel.getHeight() * 0.5));
        this.clockInPanel.add(inLabel);
        this.clockOutPanel = new JPanel();
        this.clockOutPanel.setLayout(null);
        this.clockOutPanel.setOpaque(true);
        this.clockOutPanel.setBackground(new Color(255, 100, 100));
        this.clockOutPanel.setBorder(new SoftBevelBorder(0));
        this.clockOutPanel.setBounds((int)((double)this.getWidth() * 0.25) + 1, margin, (int)((double)this.getWidth() * 0.25) - margin - 5, (int)((double)this.keyPadPanel.getHeight() * 0.15));
        this.clockOutPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimeClockFrame.this.clockOut();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TimeClockFrame.this.clockOutPanel.setBackground(new Color(255, 200, 200));
                TimeClockFrame.this.clockOutPanel.revalidate();
                TimeClockFrame.this.clockOutPanel.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TimeClockFrame.this.clockOutPanel.setBackground(new Color(255, 100, 100));
                TimeClockFrame.this.clockOutPanel.revalidate();
                TimeClockFrame.this.clockOutPanel.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.keyPadPanel.add(this.clockOutPanel);
        clockLabel = new JLabel();
        clockLabel.setText(this.getLiteral("clock"));
        clockLabel.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 24);
        clockLabel.setFont(this.font);
        clockLabel.setForeground(Color.black);
        clockLabel.setBounds(0, 0, this.clockOutPanel.getWidth(), (int)((double)this.clockOutPanel.getHeight() * 0.5));
        this.clockOutPanel.add(clockLabel);
        JLabel outLabel = new JLabel();
        outLabel.setText(this.getLiteral("OUT"));
        outLabel.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 48);
        outLabel.setFont(this.font);
        outLabel.setForeground(Color.black);
        outLabel.setBounds(0, (int)((double)this.clockOutPanel.getHeight() * 0.5), this.clockOutPanel.getWidth(), (int)((double)this.clockOutPanel.getHeight() * 0.5));
        this.clockOutPanel.add(outLabel);
        this.keyPanel = new JPanel();
        this.keyPanel.setLayout(null);
        this.keyPanel.setOpaque(true);
        this.keyPanel.setBackground(Color.black);
        this.keyPanel.setBounds(margin, (int)((double)this.getHeight() * 0.2), (int)((double)this.getWidth() * 0.5) - margin * 2 - 5, (int)((double)this.keyPadPanel.getHeight() * 0.75) - margin);
        this.keyPadPanel.add(this.keyPanel);
        JButton sevenBtn = new JButton();
        this.keyPanel.add(sevenBtn);
        sevenBtn.setText("7");
        sevenBtn.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 48);
        sevenBtn.setFont(this.font);
        sevenBtn.setForeground(Color.black);
        sevenBtn.setBounds(0, 0, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        sevenBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "7");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton eightBtn = new JButton();
        this.keyPanel.add(eightBtn);
        eightBtn.setText("8");
        eightBtn.setHorizontalAlignment(0);
        eightBtn.setFont(this.font);
        eightBtn.setForeground(Color.black);
        eightBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.333) + 1, 0, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        eightBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "8");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton nineBtn = new JButton();
        this.keyPanel.add(nineBtn);
        nineBtn.setText("9");
        nineBtn.setHorizontalAlignment(0);
        nineBtn.setFont(this.font);
        nineBtn.setForeground(Color.black);
        nineBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.666) + 1, 0, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        nineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "9");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton fourBtn = new JButton();
        this.keyPanel.add(fourBtn);
        fourBtn.setText("4");
        fourBtn.setHorizontalAlignment(0);
        fourBtn.setFont(this.font);
        fourBtn.setForeground(Color.black);
        fourBtn.setBounds(0, (int)((double)this.keyPanel.getHeight() * 0.25) + 1, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        fourBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "4");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton fiveBtn = new JButton();
        this.keyPanel.add(fiveBtn);
        fiveBtn.setText("5");
        fiveBtn.setHorizontalAlignment(0);
        fiveBtn.setFont(this.font);
        fiveBtn.setForeground(Color.black);
        fiveBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.333) + 1, (int)((double)this.keyPanel.getHeight() * 0.25) + 1, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        fiveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "5");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton sixBtn = new JButton();
        this.keyPanel.add(sixBtn);
        sixBtn.setText("6");
        sixBtn.setHorizontalAlignment(0);
        sixBtn.setFont(this.font);
        sixBtn.setForeground(Color.black);
        sixBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.666) + 1, (int)((double)this.keyPanel.getHeight() * 0.25) + 1, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        sixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "6");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton oneBtn = new JButton();
        this.keyPanel.add(oneBtn);
        oneBtn.setText("1");
        oneBtn.setHorizontalAlignment(0);
        oneBtn.setFont(this.font);
        oneBtn.setForeground(Color.black);
        oneBtn.setBounds(0, (int)((double)this.keyPanel.getHeight() * 0.5) + 2, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        oneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "1");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton twoBtn = new JButton();
        this.keyPanel.add(twoBtn);
        twoBtn.setText("2");
        twoBtn.setHorizontalAlignment(0);
        twoBtn.setFont(this.font);
        twoBtn.setForeground(Color.black);
        twoBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.333) + 1, (int)((double)this.keyPanel.getHeight() * 0.5) + 2, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        twoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "2");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton threeBtn = new JButton();
        this.keyPanel.add(threeBtn);
        threeBtn.setText("3");
        threeBtn.setHorizontalAlignment(0);
        threeBtn.setFont(this.font);
        threeBtn.setForeground(Color.black);
        threeBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.666) + 1, (int)((double)this.keyPanel.getHeight() * 0.5) + 2, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        threeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "3");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton clearBtn = new JButton();
        this.keyPanel.add(clearBtn);
        clearBtn.setText(this.getLiteral("clear"));
        clearBtn.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 24);
        clearBtn.setFont(this.font);
        clearBtn.setForeground(Color.black);
        clearBtn.setBounds(0, (int)((double)this.keyPanel.getHeight() * 0.75) + 3, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText("");
                TimeClockFrame.this.selectedPayType = null;
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton zeroBtn = new JButton();
        this.keyPanel.add(zeroBtn);
        zeroBtn.setText("0");
        zeroBtn.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 48);
        zeroBtn.setFont(this.font);
        zeroBtn.setForeground(Color.black);
        zeroBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.333) + 1, (int)((double)this.keyPanel.getHeight() * 0.75) + 3, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        zeroBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.passCodeEdit.setText(new String(TimeClockFrame.this.passCodeEdit.getPassword()) + "0");
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton backBtn = new JButton();
        this.keyPanel.add(backBtn);
        backBtn.setText(this.getLiteral("back"));
        backBtn.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 24);
        backBtn.setFont(this.font);
        backBtn.setForeground(Color.black);
        backBtn.setBounds((int)((double)this.keyPanel.getWidth() * 0.666) + 1, (int)((double)this.keyPanel.getHeight() * 0.75) + 3, (int)((double)this.keyPanel.getWidth() * 0.333), (int)((double)this.keyPanel.getHeight() * 0.25));
        backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = new String(TimeClockFrame.this.passCodeEdit.getPassword());
                if (text.length() > 0) {
                    TimeClockFrame.this.passCodeEdit.setText(text.substring(0, text.length() - 1));
                }
                TimeClockFrame.this.passCodeEdit.requestFocus();
            }
        });
        JButton exitBtn = new JButton();
        this.mainPanel.add(exitBtn);
        exitBtn.setText(this.getLiteral("Exit"));
        exitBtn.setOpaque(true);
        exitBtn.setBackground(new Color(100, 0, 0));
        exitBtn.setForeground(Color.white);
        exitBtn.setHorizontalAlignment(0);
        this.font = new Font("Arial", 1, 24);
        exitBtn.setFont(this.font);
        exitBtn.setBounds((int)((double)this.getWidth() * 0.65) - 10, (int)((double)this.getHeight() * 0.86), (int)((double)this.getWidth() * 0.2), (int)((double)this.keyPanel.getHeight() * 0.125));
        exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeClockFrame.this.dispose();
            }
        });
        int messageDialogWidth = (int)((double)this.getWidth() * 0.55);
        int messageDialogHeight = (int)((double)this.getHeight() * 0.4);
        this.messageDialog.setBounds(0, 0, messageDialogWidth, messageDialogHeight);
        this.messageDialog.setBackground(Color.black);
        this.messagePanel.setBounds(0, 0, messageDialogWidth - 2, messageDialogHeight - 2);
        this.messagePanel.setBackground(Color.black);
        this.messagePanel.setBorder(new LineBorder(Color.white, 2));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeClockFrame.this.keyPanel.revalidate();
                TimeClockFrame.this.keyPanel.repaint();
                TimeClockFrame.this.keyPadPanel.revalidate();
                TimeClockFrame.this.keyPadPanel.repaint();
                TimeClockFrame.this.mainPanel.revalidate();
                TimeClockFrame.this.mainPanel.repaint();
            }
        });
    }

    private void closeWindow() {
        if (this.keepRunning) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    private ServerConnection getServerConfig() {
        ServerConnection serverConnection = null;
        String configFilename = this.userDir + this.pathSeparator + "AccuPOSServerConnection.cfg";
        File configFile = new File(configFilename);
        if (configFile.exists() && configFile.isFile()) {
            String configXml = Utility.getXml(configFilename);
            serverConnection = new ServerConnection(configXml);
        }
        return serverConnection;
    }

    @Override
    public void setServerConnector(SocketConnector conn) {
        this.conn = conn;
    }

    public void setIcon() {
        BufferedImage image = this.readImageFromJar("AccuShiftPC.jar", "AccuPOS.png");
        this.setIconImage(image);
    }

    public BufferedImage readImageFromJar(String jarName, String source) {
        BufferedImage image = null;
        try {
            JarFile jarFile = new JarFile(jarName);
            JarEntry entry = jarFile.getJarEntry(source);
            InputStream input = jarFile.getInputStream(entry);
            image = ImageIO.read(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public void setTimeText(String text) {
        if (this.timeLabel != null) {
            this.timeLabel.setText(text);
        }
    }

    @Override
    public void handleException(Exception e) {
        StackTraceElement[] traces = e.getStackTrace();
        int len = traces.length;
        String logText = "";
        for (int i = 0; i < len; ++i) {
            logText = logText + traces[i] + "\n";
        }
        logText = logText + e.getMessage() + "\n";
        JOptionPane.showMessageDialog(this, logText, "Exception", 0);
    }

    public String getVersion() {
        return "3.9";
    }

    public String parseCode(String code) {
        int start = code.indexOf(59);
        if (start < 0) {
            start = code.indexOf(37);
        }
        int end = code.indexOf(63, start);
        String result = code;
        if (end > start) {
            result = code.substring(start + 1, end);
        }
        return result;
    }

    public void findEmployee() {
        String result = "";
        String employeeName = "";
        String[] payLevels = new String[20];
        boolean isClockedIn = false;
        this.currentEmployee = null;
        String employeeId = this.parseCode(new String(this.passCodeEdit.getPassword()));
        if (employeeId.length() > 0) {
            block7: {
                try {
                    result = this.conn.getEmployeeInfo(employeeId);
                }
                catch (Exception ex) {
                    if (result == null) break block7;
                    result = "<Status>Not Found</Status>Employee Not Found (Exception)";
                }
            }
            if (result != null) {
                String status = Utility.getElement("Status", result);
                if (status.contains("OK")) {
                    employeeId = Utility.getElement("EmployeeId", result);
                    employeeName = Utility.getElement("EmployeeName", result);
                    isClockedIn = Utility.getBooleanElement("IsClockedIn", result);
                    for (int i = 0; i < 20; ++i) {
                        payLevels[i] = Utility.getElement("PayLevel" + (i + 1), result);
                    }
                    this.currentEmployee = new Employee(employeeId, employeeName, payLevels[0], payLevels[1], payLevels[2], payLevels[3], payLevels[4], payLevels[5], payLevels[6], payLevels[7], payLevels[8], payLevels[9], payLevels[10], payLevels[11], payLevels[12], payLevels[13], payLevels[14], payLevels[15], payLevels[16], payLevels[17], payLevels[18], payLevels[19], false, isClockedIn);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Server Connection Failed \n\nCheck server address and port\n\n", "Server Connection", 0);
            }
        }
    }

    public void loadEmployeePayTypes(Employee employee) {
        ArrayList<String> payTypes = new ArrayList<String>();
        if (employee.payLevel1.length() > 0) {
            payTypes.add(employee.payLevel1);
        }
        if (employee.payLevel2.length() > 0) {
            payTypes.add(employee.payLevel2);
        }
        if (employee.payLevel3.length() > 0) {
            payTypes.add(employee.payLevel3);
        }
        if (employee.payLevel4.length() > 0) {
            payTypes.add(employee.payLevel4);
        }
        if (employee.payLevel5.length() > 0) {
            payTypes.add(employee.payLevel5);
        }
        if (employee.payLevel6.length() > 0) {
            payTypes.add(employee.payLevel6);
        }
        if (employee.payLevel7.length() > 0) {
            payTypes.add(employee.payLevel7);
        }
        if (employee.payLevel8.length() > 0) {
            payTypes.add(employee.payLevel8);
        }
        if (employee.payLevel9.length() > 0) {
            payTypes.add(employee.payLevel9);
        }
        if (employee.payLevel10.length() > 0) {
            payTypes.add(employee.payLevel10);
        }
        if (employee.payLevel11.length() > 0) {
            payTypes.add(employee.payLevel11);
        }
        if (employee.payLevel12.length() > 0) {
            payTypes.add(employee.payLevel12);
        }
        if (employee.payLevel13.length() > 0) {
            payTypes.add(employee.payLevel13);
        }
        if (employee.payLevel14.length() > 0) {
            payTypes.add(employee.payLevel14);
        }
        if (employee.payLevel15.length() > 0) {
            payTypes.add(employee.payLevel15);
        }
        if (employee.payLevel16.length() > 0) {
            payTypes.add(employee.payLevel16);
        }
        if (employee.payLevel17.length() > 0) {
            payTypes.add(employee.payLevel17);
        }
        if (employee.payLevel18.length() > 0) {
            payTypes.add(employee.payLevel18);
        }
        if (employee.payLevel19.length() > 0) {
            payTypes.add(employee.payLevel19);
        }
        if (employee.payLevel20.length() > 0) {
            payTypes.add(employee.payLevel20);
        }
        this.showPayTypePanels(payTypes);
    }

    public void clockIn() {
        this.findEmployee();
        if (this.currentEmployee == null) {
            this.showMessageBox(this.getLiteral("Please enter passCode again."), this.getLiteral("Employee not found"), this.getLiteral("OK"), null);
            this.passCodeEdit.setText("");
            this.passCodeEdit.requestFocus();
            return;
        }
        this.payLevels = Employee.getEmployeePayLevels((Employee)this.currentEmployee);
        if (this.payLevels == null || this.payLevels.isEmpty()) {
            this.currentEmployee.payLevelNumber = -1;
            boolean result = this.setEmployeeClockIn(0);
            if (result) {
                this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked IN at") + this.timeFormat.format(new Date()), this.getLiteral("Employee Clocked IN"), this.getLiteral("OK"), null);
            } else {
                this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock IN please try again!"), this.getLiteral("Employee Clocked IN Error"), this.getLiteral("OK"), null);
            }
            this.passCodeEdit.setText("");
            if (result) {
                this.checkForAutoQuit();
            }
        } else if (this.payLevels.size() == 1) {
            String payLevel = (String)this.payLevels.get(0);
            this.currentEmployee.payLevelNumber = Employee.getPayLevelNumber((Employee)this.currentEmployee, (String)payLevel);
            boolean result = this.setEmployeeClockIn(0);
            if (result) {
                this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked IN as") + " " + payLevel + " " + this.getLiteral("at") + " " + this.timeFormat.format(new Date()), this.getLiteral("Employee Clocked IN"), this.getLiteral("OK"), null);
            } else {
                this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock IN please try again!"), this.getLiteral("Employee Clocked IN Error"), this.getLiteral("OK"), null);
            }
            this.passCodeEdit.setText("");
            if (result) {
                this.checkForAutoQuit();
            }
        } else {
            this.loadEmployeePayTypes(this.currentEmployee);
            this.selectLabel.setText(this.getLiteral("Clock IN as:"));
            this.selectLabel.setVisible(true);
            this.selectBorderPanel.setVisible(true);
        }
    }

    private boolean setEmployeeClockIn(int breakId) {
        String result = "";
        boolean returnStatus = true;
        boolean clockedIntoBreak = false;
        if (this.currentEmployee != null) {
            try {
                clockedIntoBreak = this.conn.isClockedIntoBreak(this.currentEmployee.id);
            }
            catch (Exception ex) {
                clockedIntoBreak = false;
            }
            if (clockedIntoBreak) {
                this.setEmployeeClockOut();
            } else {
                String loginId = this.parseCode(new String(this.passCodeEdit.getPassword()));
                if (this.currentEmployee != null) {
                    try {
                        result = this.conn.setEmployeeClockIn(this.currentEmployee, loginId, breakId);
                    }
                    catch (Exception ex) {
                        result = "<Status>Failed</Status>Employee Post IN Failed (Exception)";
                    }
                    String status = Utility.getElement("Status", result);
                    if (status.contains("OK")) {
                        String printData = Utility.getElement("PrintData", result);
                        this.printTicket(printData);
                        returnStatus = true;
                    } else {
                        returnStatus = false;
                    }
                }
            }
        }
        return returnStatus;
    }

    public void setPayLevelSelected(String payLevelSelected) {
        this.currentEmployee.payLevelNumber = Employee.getPayLevelNumber((Employee)this.currentEmployee, (String)payLevelSelected);
        boolean result = this.setEmployeeClockIn(0);
        if (result) {
            this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked IN as") + " " + payLevelSelected + " " + this.getLiteral("at") + " " + this.timeFormat.format(new Date()), this.getLiteral("Employee Clocked IN"), this.getLiteral("OK"), null);
        } else {
            this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock IN please try again!"), this.getLiteral("Employee Clocked IN Error"), this.getLiteral("OK"), null);
        }
        this.passCodeEdit.setText("");
        this.selectBorderPanel.setVisible(false);
        if (result) {
            this.checkForAutoQuit();
        }
    }

    public void clockOut() {
        this.findEmployee();
        if (this.currentEmployee == null) {
            this.showMessageBox(this.getLiteral("Please enter passCode again."), this.getLiteral("Employee not found"), this.getLiteral("OK"), null);
            this.passCodeEdit.setText("");
            this.passCodeEdit.requestFocus();
            return;
        }
        Vector breaksVector = null;
        String breaksXml = this.conn.getBreaks();
        if (breaksXml != null && !breaksXml.isEmpty()) {
            breaksVector = Utility.getElementList("BreakInfo", breaksXml);
        }
        if (breaksVector != null && !breaksVector.isEmpty()) {
            this.clockingOut = true;
            this.breaksList = new ArrayList();
            int len = breaksVector.size();
            for (int i = 0; i < len; ++i) {
                String breakInfoXml = (String)breaksVector.get(i);
                BreakInfo breakInfo = new BreakInfo(breakInfoXml);
                this.breaksList.add(breakInfo);
            }
            BreakInfo clockOutBreak = new BreakInfo();
            clockOutBreak.type = this.getLiteral("End of Day Clock Out");
            this.breaksList.add(clockOutBreak);
            this.showBreakSelectPanels();
        } else {
            this.showMessageBox(this.getLiteral("Are you clocking Out?"), this.getLiteral("Clock Out Confirmation"), this.getLiteral("Yes"), this.getLiteral("No"));
            if (this.confirmationValue == 0) {
                boolean result = this.setEmployeeClockOut();
                if (result) {
                    this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked OUT at") + " " + this.timeFormat.format(new Date()), this.getLiteral("Employee Clocked OUT"), this.getLiteral("OK"), null);
                } else {
                    this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock OUT please try again!"), this.getLiteral("Employee Clocked OUT Error"), this.getLiteral("OK"), null);
                }
                this.passCodeEdit.setText("");
                this.passCodeEdit.requestFocus();
                if (result) {
                    this.checkForAutoQuit();
                }
            } else {
                this.passCodeEdit.setText("");
                this.passCodeEdit.requestFocus();
            }
        }
    }

    private boolean setEmployeeClockOut() {
        String result = "";
        boolean returnStatus = true;
        String loginId = this.parseCode(new String(this.passCodeEdit.getPassword()));
        if (this.currentEmployee != null) {
            try {
                result = this.conn.setEmployeeClockOut(this.currentEmployee, loginId);
            }
            catch (Exception ex) {
                result = "<Status>Failed</Status>Employee Post OUT Failed (Exception)";
            }
            String status = Utility.getElement("Status", result);
            if (status.contains("OK")) {
                String printData = Utility.getElement("PrintData", result);
                this.printTicket(printData);
                returnStatus = true;
            } else {
                returnStatus = false;
            }
        }
        return returnStatus;
    }

    public void restart() {
        TimeClockFrame newTc = new TimeClockFrame(this.autoQuit, true);
        newTc.setVisible(true);
        this.dispose();
    }

    public void showConfiguration() {
        ServerConfigScreen configScreen = new ServerConfigScreen(this, true, true);
        configScreen.displayScreen();
        configScreen.dispose();
        SocketConnector connector = null;
        ServerConnection serverConnection = this.getServerConfig();
        if (serverConnection == null) {
            JOptionPane.showMessageDialog(this, "Server connection Failed", "Server Connection", 0);
            if (this.keepRunning) {
                this.dispose();
            } else {
                System.exit(0);
            }
        } else {
            connector = new SocketConnector(this, serverConnection);
        }
    }

    @Override
    public void showPrinterConfiguration() {
        PrinterConfigScreen printerConfigScreen = new PrinterConfigScreen(this, true, true);
        printerConfigScreen.displayScreen();
        printerConfigScreen.dispose();
    }

    private void initComponents() {
        this.messageDialog = new JDialog();
        this.messagePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.messageDialog.setAlwaysOnTop(true);
        this.messageDialog.setModal(true);
        this.messageDialog.setUndecorated(true);
        this.messageDialog.getContentPane().setLayout(null);
        this.messagePanel.setBackground(new Color(204, 204, 255));
        this.messagePanel.setLayout(null);
        this.buttonPanel.setBackground(new Color(204, 204, 255));
        this.buttonPanel.setLayout(null);
        this.messagePanel.add(this.buttonPanel);
        this.buttonPanel.setBounds(0, 240, 400, 60);
        this.messageDialog.getContentPane().add(this.messagePanel);
        this.messagePanel.setBounds(0, 0, 400, 230);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setFont(new Font("Arial", 0, 24));
        this.mainPanel.setBackground(new Color(75, 75, 75));
        this.mainPanel.setBorder(BorderFactory.createLineBorder(new Color(240, 240, 240)));
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setPreferredSize(new Dimension(750, 680));
        this.mainPanel.setLayout(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        final boolean autoQuit = args.length > 0 && args[0].compareToIgnoreCase("true") == 0;
        final boolean keepRunning = args.length > 1 && args[1].compareToIgnoreCase("true") == 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeClockFrame timeclock = new TimeClockFrame(autoQuit, keepRunning);
                timeclock.setIcon();
                timeclock.setVisible(true);
                timeclock.invalidate();
                timeclock.repaint();
                timeclock.toFront();
                timeclock.setAlwaysOnTop(true);
            }
        });
    }

    @Override
    public String getPrinterTypeNames(int printerType) {
        return this.conn.getPrinterTypeNames(printerType);
    }

    @Override
    public String getPrinterConfiguration() {
        String configXml = Utility.getXml(this.userDir + this.pathSeparator + "AccuShiftPrinter.cfg");
        return configXml;
    }

    @Override
    public void savePrinterConfiguration(String configXml) {
        try {
            Utility.writeXml(this.userDir + this.pathSeparator + "AccuShiftPrinter.cfg", configXml);
            if (configXml != null && !configXml.isEmpty()) {
                this.printerDriver = Utility.getElement("PrinterDriver", configXml);
                this.timeClockPrinter = new TimeClockPrinter(this, this.printerDriver);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printTicket(String printData) {
        if (!printData.isEmpty() && this.timeClockPrinter != null) {
            String status = this.timeClockPrinter.printerStatus(this.printerDriver);
            if (status != null && status.contains("OK")) {
                this.timeClockPrinter.printTicket(printData);
            } else {
                if (status == null) {
                    status = this.getLiteral("Printer Not Found");
                }
                this.showMessageBox(this.getLiteral("Printer Status") + ": " + status, this.getLiteral("Printer Error"), this.getLiteral("OK"), null);
            }
        }
    }

    private void setClockingOut(String selectedBreakType) {
        String clockOutMessage = "";
        BreakInfo breakInfo = null;
        boolean breakSelected = false;
        int len = this.breaksList.size();
        for (int i = 0; i < len; ++i) {
            breakInfo = (BreakInfo)this.breaksList.get(i);
            if (!breakInfo.type.equals(selectedBreakType)) continue;
            clockOutMessage = this.getLiteral("Clocking Out for") + "\n" + breakInfo.type + "?";
            breakSelected = true;
            break;
        }
        boolean result = false;
        int response = -1;
        if (breakSelected && breakInfo != null && breakInfo.id > 0) {
            result = this.setEmployeeClockIn(breakInfo.id);
            if (result) {
                if (breakSelected) {
                    this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked OUT at") + " " + this.timeFormat.format(new Date()) + "\n" + "for" + " " + breakInfo.type, this.getLiteral("Employee Clocked OUT"), this.getLiteral("OK"), null);
                } else {
                    this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked OUT at") + " " + this.timeFormat.format(new Date()) + "\n" + "for the day", this.getLiteral("Employee Clocked OUT"), this.getLiteral("OK"), null);
                }
            } else {
                this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock OUT please try again!"), this.getLiteral("Employee Clocked OUT Error"), this.getLiteral("OK"), null);
                this.clockingOut = false;
                this.passCodeEdit.setText("");
                return;
            }
            this.passCodeEdit.setText("");
            this.passCodeEdit.requestFocus();
            this.clockingOut = false;
            return;
        }
        if (breakInfo == null || breakInfo.id == 0) {
            if (!breakSelected) {
                clockOutMessage = this.getLiteral("Clocking Out for the day?");
            }
            this.showMessageBox(clockOutMessage, this.getLiteral("Clock Out Confirmation"), this.getLiteral("Yes"), this.getLiteral("No"));
            response = this.confirmationValue;
            if (response == 0) {
                String payLevelXml = this.conn.getClockInPayLevel(this.currentEmployee);
                this.currentEmployee.payLevelNumber = Utility.getIntElement("PayLevel", payLevelXml);
                result = this.setEmployeeClockOut();
                if (result) {
                    if (breakSelected) {
                        this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked OUT at") + " " + this.timeFormat.format(new Date()) + "\n" + "for" + " " + breakInfo.type, this.getLiteral("Employee Clocked OUT"), this.getLiteral("OK"), null);
                    } else {
                        this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("clocked OUT at") + " " + this.timeFormat.format(new Date()) + "\n" + "for the day", this.getLiteral("Employee Clocked OUT"), this.getLiteral("OK"), null);
                    }
                } else {
                    this.showMessageBox(this.currentEmployee.name + " " + this.getLiteral("Failed to clock OUT please try again!"), this.getLiteral("Employee Clocked OUT Error"), this.getLiteral("OK"), null);
                    this.clockingOut = false;
                    this.passCodeEdit.setText("");
                    return;
                }
            }
        }
        this.passCodeEdit.setText("");
        this.passCodeEdit.requestFocus();
        this.clockingOut = false;
        if (response == 0) {
            this.checkForAutoQuit();
        }
    }

    private void showPayTypePanels(ArrayList payTypes) {
        int btnHeight = (int)((double)this.getHeight() * 0.075);
        int btnWidth = (int)((double)this.getWidth() * 0.375);
        int btnLeft = (int)((double)this.getWidth() * 0.06);
        int btnOffset = (int)((double)this.getWidth() * 0.035);
        Image upImage = Utility.getImage("alertBlueUp.png");
        Image downImage = Utility.getImage("alertBlueUp.png");
        this.selectPanel.removeAll();
        this.selectPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        int len = 0;
        if (payTypes != null) {
            len = payTypes.size();
            for (int i = 0; i < len; ++i) {
                String payType = (String)payTypes.get(i);
                final ButtonPanel panel = new ButtonPanel(this, btnHeight, btnWidth, upImage, downImage, this.font, payType, Color.black);
                panel.setBackground(this.backColor);
                panel.setBounds(btnLeft, btnOffset * (i + 1) + btnHeight * i, btnWidth, btnHeight);
                this.selectPanel.add(panel);
                panel.addMouseListener(null);
                panel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        TimeClockFrame.this.setPanelSelected(panel);
                    }
                });
            }
        }
        this.selectPanel.revalidate();
        this.selectPanel.repaint();
        this.selectLabel.setText(this.getLiteral("Clock IN as:"));
        this.selectLabel.setVisible(true);
        this.selectBorderPanel.setVisible(true);
        int maxHeight = len * (btnOffset * 2 + btnHeight);
        int panelHeight = this.selectPanel.getHeight();
        if (maxHeight > panelHeight) {
            this.selectPanel.setPreferredSize(new Dimension(this.selectPanel.getWidth(), maxHeight));
            this.selectScrollUpBtn.setVisible(true);
            this.selectScrollDownBtn.setVisible(true);
        }
    }

    private void showBreakSelectPanels() {
        int btnHeight = (int)((double)this.getHeight() * 0.075);
        int btnWidth = (int)((double)this.getWidth() * 0.375);
        int btnLeft = (int)((double)this.getWidth() * 0.06);
        int btnOffset = (int)((double)this.getWidth() * 0.035);
        Image upImage = Utility.getImage("alertBlueUp.png");
        Image downImage = Utility.getImage("alertBlueUp.png");
        this.selectPanel.removeAll();
        this.selectPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        int len = 0;
        if (this.breaksList != null) {
            len = this.breaksList.size();
            for (int i = 0; i < len; ++i) {
                BreakInfo breakInfo = (BreakInfo)this.breaksList.get(i);
                final ButtonPanel panel = new ButtonPanel(this, btnHeight, btnWidth, upImage, downImage, this.font, breakInfo.type, Color.black);
                panel.setBackground(this.backColor);
                panel.setBounds(btnLeft, btnOffset * (i + 1) + btnHeight * i, btnWidth, btnHeight);
                this.selectPanel.add(panel);
                panel.addMouseListener(null);
                panel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        TimeClockFrame.this.setPanelSelected(panel);
                    }
                });
            }
        }
        this.selectPanel.revalidate();
        this.selectPanel.repaint();
        this.selectLabel.setText(this.getLiteral("Clock OUT as:"));
        this.selectLabel.setVisible(true);
        this.selectBorderPanel.setVisible(true);
        int maxHeight = len * (btnOffset * 2 + btnHeight);
        int panelHeight = this.selectPanel.getHeight();
        if (maxHeight > panelHeight) {
            this.selectPanel.setPreferredSize(new Dimension(this.selectPanel.getWidth(), maxHeight));
            this.selectScrollUpBtn.setVisible(true);
            this.selectScrollDownBtn.setVisible(true);
        }
    }

    public void setPanelSelected(ButtonPanel panel) {
        if (this.clockingOut) {
            String selectedBreakType = panel.getText();
            this.setClockingOut(selectedBreakType);
        } else {
            this.selectedPayType = panel.getText();
            this.setPayLevelSelected(this.selectedPayType);
        }
        this.selectLabel.setVisible(false);
        this.selectBorderPanel.setVisible(false);
        this.selectScrollUpBtn.setVisible(false);
        this.selectScrollDownBtn.setVisible(false);
    }

    private void checkForAutoQuit() {
        if (this.autoQuit) {
            if (this.keepRunning) {
                this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    @Override
    public void showMessageBox(String message, String title, String button1Text, String button2Text) {
        ButtonPanel button1 = null;
        ButtonPanel button2 = null;
        int screenWidth = this.messagePanel.getWidth();
        int screenHeight = this.messagePanel.getHeight();
        this.fontLarge = new Font("Arial", 1, 24);
        this.fontStandard = new Font("Arial", 0, 18);
        this.messagePanel.removeAll();
        this.messagePanel.revalidate();
        if (title != null || !title.isEmpty()) {
            JLabel titleLabel = new JLabel();
            titleLabel.setBounds(2, (int)((double)screenHeight * 0.05), screenWidth - 4, (int)((double)screenHeight * 0.1));
            titleLabel.setText(title);
            titleLabel.setFont(this.fontLarge);
            titleLabel.setForeground(Color.white);
            titleLabel.setHorizontalAlignment(0);
            titleLabel.setVerticalAlignment(0);
            this.messagePanel.add(titleLabel);
        }
        if (message != null || !message.isEmpty()) {
            JTextPane messagePane = new JTextPane();
            messagePane.setBounds(2, (int)((double)screenHeight * 0.3), screenWidth - 4, (int)((double)screenHeight * 0.4));
            messagePane.setText(message);
            messagePane.setFont(this.fontStandard);
            messagePane.setBackground(Color.black);
            messagePane.setForeground(Color.white);
            SimpleAttributeSet bSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(bSet, 1);
            StyledDocument doc = messagePane.getStyledDocument();
            doc.setParagraphAttributes(0, message.length(), bSet, false);
            this.messagePanel.add(messagePane);
        }
        this.buttonPanel.removeAll();
        this.buttonPanel.setBackground(Color.black);
        this.buttonPanel.setBounds(2, (int)((double)screenHeight * 0.675), screenWidth - 4, (int)((double)screenHeight * 0.325));
        this.messagePanel.add(this.buttonPanel);
        button1 = this.getButton(0, button1Text);
        this.buttonPanel.add(button1);
        int panelWidth = this.buttonPanel.getWidth();
        int panelHeight = this.buttonPanel.getHeight();
        if (button2Text == null || button2Text.isEmpty()) {
            button1.setLocation((int)((double)panelWidth * 0.35), (int)((double)panelHeight * 0.25));
        } else {
            button2 = this.getButton(1, button2Text);
            this.buttonPanel.add(button2);
            button1.setLocation((int)((double)panelWidth * 0.15), (int)((double)panelHeight * 0.25));
            button2.setLocation((int)((double)panelWidth * 0.55), (int)((double)panelHeight * 0.25));
        }
        SwingUtilities.invokeLater(new DisplayMessageBox());
        this.messageDialog.setLocationRelativeTo(this);
        this.messageDialog.setAlwaysOnTop(true);
        this.messageDialog.setVisible(true);
    }

    public ButtonPanel getButton(final int buttonId, String text) {
        Image imageUp = null;
        Image imageDown = null;
        if (text.equalsIgnoreCase(this.getLiteral("OK")) || text.equalsIgnoreCase(this.getLiteral("Yes"))) {
            imageUp = Utility.getImage("alertBlueUp.png");
            imageDown = Utility.getImage("alertBlueDown.png");
        } else if (text.equalsIgnoreCase(this.getLiteral("Cancel")) || text.equalsIgnoreCase(this.getLiteral("No"))) {
            imageUp = Utility.getImage("alertRedUp.png");
            imageDown = Utility.getImage("alertRedDown.png");
        } else {
            imageUp = Utility.getImage("alertGreenUp.png");
            imageDown = Utility.getImage("alertGreenDown.png");
        }
        int buttonWidth = (int)((double)this.buttonPanel.getWidth() * 0.3);
        int buttonHeight = (int)((double)this.buttonPanel.getHeight() * 0.5);
        ButtonPanel button = new ButtonPanel(this, buttonWidth, buttonHeight, imageUp, imageDown, this.fontLarge, text, Color.black);
        button.setBorder(null);
        button.setBackground(this.backColor);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TimeClockFrame.this.confirmationValue = buttonId;
                TimeClockFrame.this.messageDialog.setAlwaysOnTop(false);
                TimeClockFrame.this.messageDialog.setVisible(false);
                TimeClockFrame.this.messageDialog.dispose();
            }
        });
        return button;
    }

    @Override
    public String getLiteral(String name) {
        String result = (String)this.literalsTable.get(name);
        return result == null ? name : result;
    }

    class DisplayMessageBox
    implements Runnable {
        DisplayMessageBox() {
        }

        @Override
        public void run() {
            TimeClockFrame.this.messagePanel.revalidate();
            TimeClockFrame.this.messagePanel.repaint();
        }
    }

    public class SetTime
    extends TimerTask {
        @Override
        public void run() {
            GregorianCalendar now = new GregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("h:mm a");
            TimeClockFrame.this.setTimeText(dateFormat.format(now.getTime()));
        }
    }
}

