/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuServerBase.Utility;
import AccuShiftPC.PrintData;
import AccuShiftPC.TicketPrinter;
import AccuShiftPC.TimeClockBase;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintServiceAttributeSet;

public class TimeClockPrinter {
    static String driverName = "";
    static String settings = "";
    TimeClockBase program = null;
    BufferedImage printLogo = null;
    public boolean waitingForTear = false;
    public byte codePage = 0;
    public int copies = 1;
    Hashtable fonts = new Hashtable();
    String defaultFont = null;
    String data = null;
    Vector fieldList = null;
    int sectionTop = 0;
    int sectionLeft = 0;
    int sectionHeight = 0;
    int printBottom = 0;

    public TimeClockPrinter(TimeClockBase parent, String driverName) {
        this.program = parent;
        TimeClockPrinter.driverName = driverName;
    }

    public void printTicket(String data) {
        this.printBottom = 0;
        this.fieldList = new Vector();
        this.data = data;
        String fontData = Utility.getElement((String)"Fonts", (String)data);
        Vector fontsXml = Utility.getElementList((String)"Font", (String)fontData);
        int fontsLen = fontsXml.size();
        for (int i = 0; i < fontsLen; ++i) {
            String thisFontXml = (String)fontsXml.get(i);
            String name = Utility.getElement((String)"Name", (String)thisFontXml);
            String id = Utility.getElement((String)"Id", (String)thisFontXml);
            int size = (int)Utility.getDoubleElement((String)"Size", (String)thisFontXml);
            String style = Utility.getElement((String)"Style", (String)thisFontXml);
            int typeStyle = 0;
            if (style.equalsIgnoreCase("Italic")) {
                typeStyle = 2;
            }
            if (style.equalsIgnoreCase("Bold")) {
                typeStyle = 1;
            }
            if (style.equalsIgnoreCase("BoldItalic")) {
                typeStyle = 3;
            }
            Font font = new Font(name, typeStyle, size);
            this.fonts.put(id, font);
            if (this.defaultFont != null) continue;
            this.defaultFont = id;
        }
        if (this.defaultFont == null) {
            this.program.handleException(new RuntimeException("No printer fonts defined"));
            return;
        }
        String sectionText = this.getSectionParameters("ClockInBlock", data);
        this.getSectionPrintData(sectionText);
        sectionText = this.getSectionParameters("ClockOutBlock", data);
        this.getSectionPrintData(sectionText);
        PrintThread printThread = new PrintThread(this.fieldList, driverName);
        printThread.start();
    }

    private String getSectionParameters(String sectionName, String xml) {
        Hashtable sectionParameters = new Hashtable();
        String sectionText = Utility.getElement((String)sectionName, (String)xml, sectionParameters);
        String sectionTopText = (String)sectionParameters.get("Top");
        String sectionLeftText = (String)sectionParameters.get("Left");
        String sectionHeightText = (String)sectionParameters.get("Height");
        try {
            if (sectionTopText != null) {
                this.sectionTop = Integer.parseInt(sectionTopText);
            }
        }
        catch (Exception e) {
            this.sectionTop = 0;
        }
        try {
            if (sectionLeftText != null) {
                this.sectionLeft = Integer.parseInt(sectionLeftText);
            }
        }
        catch (Exception e) {
            this.sectionLeft = 0;
        }
        try {
            if (sectionHeightText != null) {
                this.sectionHeight = Integer.parseInt(sectionHeightText);
            }
        }
        catch (Exception e) {
            this.sectionHeight = 0;
        }
        return sectionText;
    }

    private void getSectionPrintData(String sectionText) {
        int maxBottom = this.printBottom;
        int previousTop = -1;
        Vector parameters = new Vector();
        Vector fields = Utility.getElementList((String)"Field", (String)sectionText, parameters);
        int len = fields.size();
        for (int i = 0; i < len; ++i) {
            String fieldData = (String)fields.get(i);
            if (fieldData == null || fieldData.length() <= 0) continue;
            Hashtable fieldParameters = (Hashtable)parameters.get(i);
            String fieldFont = (String)fieldParameters.get("Font");
            if (fieldFont == null || fieldFont.length() == 0) {
                fieldFont = this.defaultFont;
            }
            Font thisFont = (Font)this.fonts.get(fieldFont);
            String fieldTopText = (String)fieldParameters.get("Top");
            String fieldLeftText = (String)fieldParameters.get("Left");
            String fieldAlign = (String)fieldParameters.get("Align");
            if (fieldAlign == null || fieldAlign.length() == 0) {
                fieldAlign = "Left";
            }
            int fieldTop = 0;
            try {
                if (fieldTopText != null) {
                    fieldTop = Integer.parseInt(fieldTopText);
                }
            }
            catch (Exception e) {
                fieldTop = 0;
            }
            int fieldLeft = 0;
            try {
                if (fieldLeftText != null) {
                    fieldLeft = Integer.parseInt(fieldLeftText);
                }
            }
            catch (Exception e) {
                fieldLeft = 0;
            }
            PrintData thisData = new PrintData();
            thisData.text = fieldData;
            thisData.align = fieldAlign;
            thisData.left = this.sectionLeft + fieldLeft;
            maxBottom = thisData.top = this.printBottom + this.sectionTop + fieldTop;
            if (previousTop == thisData.top) {
                int listSize = this.fieldList.size();
                PrintData prevData = (PrintData)this.fieldList.get(listSize - 1);
                prevData.maxRight = thisData.left;
            }
            previousTop = thisData.top;
            thisData.font = thisFont;
            this.fieldList.add(thisData);
        }
        this.printBottom = maxBottom;
    }

    public String printerStatus(String driverName) {
        PrintService printService = null;
        PrintService[] services = PrinterJob.lookupPrintServices();
        int len = services.length;
        for (int i = 0; i < len; ++i) {
            if (!services[i].getName().equalsIgnoreCase(driverName)) continue;
            printService = services[i];
            break;
        }
        if (printService == null) {
            return null;
        }
        String attributeName = "";
        String attributeValue = "";
        PrintServiceAttributeSet att = printService.getAttributes();
        Attribute[] attList = att.toArray();
        for (int i = 0; i < attList.length; ++i) {
            attributeName = attList[i].getName();
            if (!attributeName.equalsIgnoreCase("printer-is-accepting-jobs")) continue;
            attributeValue = att.get(attList[i].getClass()).toString();
            System.out.println("***** " + attributeName + " : " + attributeValue);
        }
        if (attributeValue.equalsIgnoreCase("accepting-jobs")) {
            return "OK";
        }
        return attributeValue;
    }

    class RawDataPrintThread
    extends Thread {
        byte[] byteCodes = null;
        String driverName = "";

        public RawDataPrintThread(byte[] byteCodes, String driverName) {
            this.byteCodes = byteCodes;
            this.driverName = driverName;
        }

        @Override
        public void run() {
            TicketPrinter ticketPrinter = new TicketPrinter();
            ticketPrinter.printData(this.driverName, this.byteCodes);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                TimeClockPrinter.this.program.handleException(ex);
            }
        }
    }

    class PrintThread
    extends Thread {
        Vector printList = null;
        String driverName = "";

        public PrintThread(Vector printList, String driverName) {
            this.printList = printList;
            this.driverName = driverName;
        }

        @Override
        public void run() {
            TicketPrinter ticketPrinter = new TicketPrinter();
            ticketPrinter.printData(this.driverName, this.printList);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                TimeClockPrinter.this.program.handleException(ex);
            }
        }
    }
}

