/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftPC;

import AccuShiftPC.SocketConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class Utility {
    public static StringBuffer log = null;

    public static String getExceptionText(Exception e) {
        StackTraceElement[] traces = e.getStackTrace();
        int len = traces.length;
        String logText = e.getLocalizedMessage() + "\r\n";
        for (int i = 0; i < len; ++i) {
            logText = logText + traces[i] + "\n";
        }
        return logText;
    }

    public static Font pickFont(Component component, String[] lines) {
        Graphics g = component.getGraphics();
        Font thisFont = component.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        int high = fontMetrics.getHeight();
        double thisHigh = (double)component.getHeight() * (1.0 / (double)lines.length) * 0.8;
        double thisWide = (double)component.getWidth() * 0.7;
        int wide = 0;
        int thisWideReference = 0;
        for (int l = 0; l < lines.length; ++l) {
            int thisWidth = fontMetrics.stringWidth(lines[l]);
            if (wide >= thisWidth) continue;
            wide = thisWidth;
            thisWideReference = l;
        }
        float size = thisFont.getSize();
        while ((double)high < thisHigh && size < 72.0f && (double)wide < thisWide) {
            thisFont = thisFont.deriveFont(size += 1.0f);
            component.setFont(thisFont);
            g.setFont(thisFont);
            fontMetrics = g.getFontMetrics();
            high = fontMetrics.getHeight();
            wide = fontMetrics.stringWidth(lines[thisWideReference]);
        }
        while ((double)high > thisHigh && size > 6.0f && (double)wide > thisWide) {
            thisFont = thisFont.deriveFont(size -= 1.0f);
            component.setFont(thisFont);
            g.setFont(thisFont);
            fontMetrics = g.getFontMetrics();
            high = fontMetrics.getHeight();
            wide = fontMetrics.stringWidth(lines[thisWideReference]);
        }
        return thisFont;
    }

    public static String[] wrapText(String text, Graphics g, Font font, double width, double[] lineHeight) {
        Vector<String> result = new Vector<String>();
        FontMetrics metrics = g.getFontMetrics(font);
        lineHeight[0] = 10.0;
        int len = text.length();
        String line = "";
        String word = "";
        String temp = "";
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            temp = word + c;
            Rectangle2D rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > lineHeight[0]) {
                lineHeight[0] = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                result.add(word);
                word = "";
            }
            word = word + c;
            temp = line + word;
            rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > lineHeight[0]) {
                lineHeight[0] = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                if (line.length() > 0) {
                    result.add(line);
                }
                line = "";
            } else if (c == '\n') {
                line = line + word;
                word = "";
                String thisLine = line.trim();
                if (thisLine != null && thisLine.length() > 0) {
                    result.add(line);
                }
                line = "";
            }
            if (c != ' ') continue;
            line = line + word;
            word = "";
        }
        if (word.length() > 0) {
            line = line + word;
        }
        if (line.length() > 0) {
            result.add(line);
        }
        len = result.size();
        String[] returnValue = new String[len];
        for (int i = 0; i < len; ++i) {
            returnValue[i] = ((String)result.get(i)).trim();
        }
        return returnValue;
    }

    public static void showMessage(Component program, String message) {
        JOptionPane.showMessageDialog(program, message);
    }

    public static boolean confirmMessage(Component program, String message) {
        int result = JOptionPane.showConfirmDialog(program, message);
        return result == 0;
    }

    public static Image getImage(String imageName) {
        Image image = null;
        String userDir = System.getProperty("user.dir");
        String pathSeparator = System.getProperty("file.separator");
        String imageFilename = userDir + pathSeparator + "Screens" + pathSeparator + "images" + pathSeparator + imageName;
        image = Toolkit.getDefaultToolkit().getImage(imageFilename);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXml(String filename, String xml) throws IOException {
        File outFile = new File(filename);
        FileOutputStream fileStream = new FileOutputStream(outFile);
        OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
        try (BufferedWriter out = new BufferedWriter(outStream);){
            out.write(xml);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        long length = 1L;
        FileInputStream is = null;
        if (!file.exists()) {
            return new byte[1];
        }
        is = new FileInputStream(file);
        length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        if (is != null) {
            ((InputStream)is).close();
        }
        return bytes;
    }

    public static Color colorFromXml(String xml) {
        int red = Utility.getIntElement("Red", xml);
        int green = Utility.getIntElement("Green", xml);
        int blue = Utility.getIntElement("Blue", xml);
        Color result = new Color(red, green, blue);
        return result;
    }

    public static String getColorXml(Color color) {
        String xml = "<Red>" + color.getRed() + "</Red><Green>" + color.getGreen() + "</Green><Blue>" + color.getBlue() + "</Blue>";
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXml(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        StringBuffer xml = new StringBuffer();
        FileInputStream fstream = null;
        try {
            String strLine;
            fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((strLine = br.readLine()) != null) {
                xml.append(strLine + "\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return xml.toString();
    }

    public static String getElement(String name, String xml, Hashtable parameters) {
        String result = "";
        String startTag = "<" + name;
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String lastName = "";
        String parametersText = xml.substring(startPos + startTag.length(), startTagEnd);
        String[] pairs = parametersText.split(" ");
        for (int i = 0; i < pairs.length; ++i) {
            String[] thisPair = pairs[i].split("=");
            if (thisPair.length > 1) {
                lastName = thisPair[0].trim();
                if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                parameters.put(lastName, thisPair[1]);
                continue;
            }
            if (lastName == null || lastName.length() <= 0) continue;
            String value = (String)parameters.get(lastName);
            if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
            parameters.put(lastName, value);
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            result = xml.substring(++startTagEnd, endPos);
        }
        return result;
    }

    public static int getIntElement(String name, String xml) {
        int result = 0;
        String intText = Utility.getElement(name, xml);
        if (intText != null && intText.length() > 0 && intText.compareToIgnoreCase("null") != 0) {
            result = Integer.parseInt(intText);
        }
        return result;
    }

    public static long getLongElement(String name, String xml) {
        long result = 0L;
        String longText = Utility.getElement(name, xml);
        if (longText != null && longText.length() > 0) {
            result = Long.parseLong(longText);
        }
        return result;
    }

    public static boolean getBooleanElement(String name, String xml) {
        return Utility.getBooleanElement(name, xml, false);
    }

    public static boolean getBooleanElement(String name, String xml, boolean defaultValue) {
        String booleanText = Utility.getElement(name, xml);
        if (booleanText == null || booleanText.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(booleanText);
    }

    public static double getDoubleElement(String name, String xml) {
        double result = 0.0;
        String doubleText = Utility.getElement(name, xml);
        if (doubleText != null && doubleText.length() > 0) {
            result = Double.parseDouble(doubleText);
        }
        return result;
    }

    public static String getElement(String name, String xml) {
        String result = "";
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String getXmlBlock(String name, String xml) {
        String result = "";
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag) + endTag.length();
        if (endPos > startPos) {
            result = xml.substring(startPos, endPos);
        }
        return result;
    }

    public static String replaceXmlDataTag(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "<" + tag + ">";
        int start = source.indexOf(startTag);
        int end = start + startTag.length();
        if (start < 0) {
            return source;
        }
        result.append(source.substring(0, start));
        result.append(replacement);
        result.append(source.substring(end));
        String reply = new String(result);
        int secondStart = source.indexOf(startTag);
        if (secondStart >= 0) {
            reply = Utility.replaceDataTag(reply, tag, replacement);
        }
        return reply;
    }

    public static String replaceXmlBlock(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "<" + tag;
        String endTag = "</" + tag + ">";
        int start = source.indexOf(startTag);
        if (start < 0) {
            return source;
        }
        int end = source.indexOf(endTag, start);
        result.append(source.substring(0, start));
        result.append(replacement);
        String endText = source.substring(end += endTag.length());
        result.append(endText);
        return new String(result);
    }

    public static String getBlock(String name, String xml) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "{" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String replaceDataTag(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        int start = source.indexOf(startTag);
        int end = start + startTag.length();
        if (start < 0) {
            return source;
        }
        result.append(source.substring(0, start));
        result.append(replacement);
        result.append(source.substring(end));
        String reply = new String(result);
        int secondStart = source.indexOf(startTag);
        if (secondStart >= 0) {
            reply = Utility.replaceDataTag(reply, tag, replacement);
        }
        return reply;
    }

    public static String replaceBlock(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        String endTag = "{/" + tag + "}";
        int start = source.indexOf(startTag);
        if (start < 0) {
            return source;
        }
        int end = source.indexOf(endTag, start);
        result.append(source.substring(0, start));
        result.append(replacement);
        String endText = source.substring(end += endTag.length());
        result.append(endText);
        return new String(result);
    }

    public static Vector getElementList(String name, String xml) {
        Vector<String> result = new Vector<String>();
        int blockStart = 0;
        int blockEnd = 0;
        boolean done = false;
        while (!done) {
            blockStart = xml.indexOf("<" + name, blockEnd);
            int startTagEnd = xml.indexOf(">", blockStart);
            blockEnd = xml.indexOf("</" + name + ">", blockStart);
            if (startTagEnd > blockStart && blockStart >= 0 && blockEnd > blockStart) {
                int dataStart = startTagEnd + 1;
                int dataEnd = blockEnd;
                String temp = xml.substring(dataStart, dataEnd);
                result.add(temp);
                continue;
            }
            done = true;
        }
        return result;
    }

    public static Vector getElementList(String name, String xml, Vector parameters) {
        Vector<String> result = new Vector<String>();
        int blockStart = 0;
        int blockEnd = 0;
        boolean done = false;
        while (!done) {
            blockStart = xml.indexOf("<" + name, blockEnd);
            blockEnd = xml.indexOf("</" + name + ">", blockStart);
            if (blockStart >= 0 && blockEnd > blockStart) {
                int dataEnd = blockEnd;
                int startTagEnd = xml.indexOf(">", blockStart);
                if (startTagEnd <= blockStart) continue;
                Hashtable<String, String> theseParameters = new Hashtable<String, String>();
                String lastName = "";
                String parametersText = xml.substring(blockStart + name.length() + 1, startTagEnd);
                String[] pairs = parametersText.split(" ");
                for (int i = 0; i < pairs.length; ++i) {
                    String[] thisPair = pairs[i].split("=");
                    if (thisPair.length > 1) {
                        lastName = thisPair[0].trim();
                        if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                        theseParameters.put(lastName, thisPair[1]);
                        continue;
                    }
                    if (lastName == null || lastName.length() <= 0) continue;
                    String value = (String)theseParameters.get(lastName);
                    if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
                    theseParameters.put(lastName, value);
                }
                parameters.add(theseParameters);
                String temp = xml.substring(startTagEnd + 1, dataEnd);
                result.add(temp);
                continue;
            }
            done = true;
        }
        return result;
    }

    public String readSocketBytes(Socket socket, String tag) throws Exception {
        StringBuffer replyString = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        try {
            String readLine;
            while ((readLine = reader.readLine()) != null) {
                replyString.append(readLine + "\n");
            }
        }
        catch (Exception e) {
            reader.close();
            return null;
        }
        reader.close();
        return replyString.toString();
    }

    public byte[] zip(byte[] zipData) {
        if (zipData == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(out);
            ZipEntry entry = new ZipEntry("data");
            zipOut.putNextEntry(entry);
            zipOut.write(zipData);
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return out.toByteArray();
    }

    public byte[] unzip(byte[] zipData) {
        if (zipData == null) {
            return null;
        }
        byte[] data = null;
        byte[] result = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(zipData);
            ZipInputStream zipIn = new ZipInputStream(in);
            ZipEntry entry = zipIn.getNextEntry();
            System.out.println(" zip entry name " + entry.getName());
            if (!entry.isDirectory()) {
                long size = entry.getSize();
                size = 32000L;
                data = new byte[(int)size];
                while (zipIn.available() > 0) {
                    data = new byte[(int)size];
                    int count = zipIn.read(data, 0, (int)size);
                    if (count <= -1) continue;
                    System.out.println(new String(data));
                    if (result == null) {
                        result = new byte[count];
                        System.arraycopy(data, 0, result, 0, count);
                        continue;
                    }
                    int newSize = result.length + count;
                    byte[] newResult = new byte[newSize];
                    System.arraycopy(result, 0, newResult, 0, result.length);
                    System.arraycopy(data, 0, newResult, result.length, count);
                    result = newResult;
                }
                return result;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void postTime() {
        Date now = new Date();
        System.out.println(now.getTime());
    }

    public String sendRequest(Socket socket, String request) throws Exception {
        String replyString = null;
        if (socket != null) {
            BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF8");
            out.write(request);
            out.flush();
            Utility utility = new Utility();
            replyString = utility.readSocketBytes(socket, "POSServerRequest");
            out.close();
        }
        return replyString;
    }

    public static void sendReply(Socket socket, String reply, String status) throws IOException {
        String replyXML = "<POSReply>\n";
        replyXML = replyXML + "    <Status>" + status + "</Status>\n";
        replyXML = replyXML + "    <Message>" + reply + "</Message>\n";
        replyXML = replyXML + "</POSReply>\n";
        PrintStream ps = new PrintStream(socket.getOutputStream());
        ps.println(replyXML);
        ps.flush();
        ps.close();
    }

    public static int convertColor(Color colorValue) {
        int red = colorValue.getRed();
        int green = colorValue.getGreen();
        int blue = colorValue.getBlue();
        if (red == 255 && green == 255 && blue == 255) {
            blue = 0;
            green = 0;
            red = 0;
        }
        int result = blue * 65536 + green * 256 + red;
        return result;
    }

    public static Color translateColor(int colorValue) {
        if (colorValue < 0) {
            return new Color(192, 192, 192);
        }
        int red = colorValue & 0xFF;
        int green = colorValue & 0xFF00;
        int blue = colorValue & 0xFF0000;
        if (red == 255 && (blue /= 65536) == 255 && (green /= 256) == 255) {
            blue = 0;
            green = 0;
            red = 0;
        }
        return new Color(red, green, blue);
    }

    public static boolean writeZipFile(String zipFilename, String sourceFilename) {
        boolean result = false;
        try {
            int len;
            String outFilename = zipFilename;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            byte[] buf = new byte[1024];
            out.putNextEntry(new ZipEntry(sourceFilename));
            FileInputStream in = new FileInputStream(sourceFilename);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            out.close();
            in.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean readZipFile(String zipFilename, String path) {
        boolean result = false;
        try {
            int len;
            String inFilename = zipFilename;
            ZipInputStream in = new ZipInputStream(new FileInputStream(inFilename));
            ZipEntry entry = in.getNextEntry();
            String outFilename = path;
            System.out.println("archive=" + entry.getName() + ", output=" + outFilename);
            FileOutputStream out = new FileOutputStream(outFilename);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String insertSpecial(String source) {
        String result = source;
        if (source == null) {
            return "";
        }
        int len = result.length();
        String result2 = "";
        for (int i = 0; i < len; ++i) {
            char thisChar = result.charAt(i);
            char val = thisChar;
            if (val > '\u0080') {
                result2 = result2 + "&#";
                result2 = result2 + new Integer(val).toString();
                result2 = result2 + ';';
                continue;
            }
            result2 = result2 + thisChar;
        }
        return result2;
    }

    public static String fixString(String source) {
        if (source == null) {
            return " ";
        }
        if (source.length() == 0) {
            return " ";
        }
        return source;
    }

    public static double roundDoubleToPennies(double source) {
        long number = Math.round(source * 100.0);
        double result = new Double(number) / 100.0;
        return result;
    }

    public static double roundDoubleToFourPlaces(double source) {
        long number = Math.round(source * 100000.0);
        double result = new Double(number) / 100000.0;
        return result;
    }

    public static String fixStringNoPad(String source) {
        if (source == null) {
            return "";
        }
        if (source.length() == 0) {
            return "";
        }
        return source;
    }

    public static Hashtable getLiteralsTable(SocketConnector connector) {
        Hashtable<String, String> literalsTable = new Hashtable<String, String>();
        String literalsXml = connector.getLiterals();
        Vector literalsList = Utility.getElementList("Literal", literalsXml);
        int len = literalsList.size();
        for (int i = 0; i < len; ++i) {
            String literalXml = (String)literalsList.get(i);
            String name = Utility.getLiteralElement("Name", literalXml);
            String text = Utility.getLiteralElement("Text", literalXml);
            if (text == null) continue;
            literalsTable.put(name, text);
        }
        return literalsTable;
    }

    private static String getLiteralElement(String name, String xml) {
        String result = null;
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return null;
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return null;
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }
}

